/*
 * Decompiled with CFR 0.152.
 */
package com.cloudbees.jenkins.plugins.amazonecs;

import com.cloudbees.jenkins.plugins.amazonecs.ECSSlave;
import hudson.model.Executor;
import hudson.model.Queue;
import hudson.slaves.AbstractCloudComputer;
import hudson.slaves.AbstractCloudSlave;
import java.util.logging.Level;
import java.util.logging.Logger;

public class ECSComputer
extends AbstractCloudComputer<ECSSlave> {
    private static final Logger LOGGER = Logger.getLogger(ECSComputer.class.getName());

    public ECSComputer(ECSSlave slave) {
        super((AbstractCloudSlave)slave);
    }

    public void taskAccepted(Executor executor, Queue.Task task) {
        super.taskAccepted(executor, task);
        LOGGER.log(Level.INFO, "[{0}]: JobName: {1}", new Object[]{this.getName(), task.getDisplayName()});
        LOGGER.log(Level.INFO, "[{0}]: JobUrl: {1}", new Object[]{this.getName(), task.getUrl()});
        LOGGER.log(Level.FINE, "[{0}]: taskAccepted", (Object)this);
    }

    public void taskCompleted(Executor executor, Queue.Task task, long durationMS) {
        super.taskCompleted(executor, task, durationMS);
        LOGGER.log(Level.FINE, "[{0}]: taskCompleted", (Object)this);
    }

    public void taskCompletedWithProblems(Executor executor, Queue.Task task, long durationMS, Throwable problems) {
        super.taskCompletedWithProblems(executor, task, durationMS, problems);
        LOGGER.log(Level.FINE, "[{0}]: taskCompletedWithProblems", (Object)this);
    }

    public String toString() {
        return String.format("ECSComputer name: %s agent: %s", this.getName(), this.getNode());
    }
}

