/*
 * Decompiled with CFR 0.152.
 */
package com.cloudbees.jenkins.plugins.amazonecr;

import com.cloudbees.jenkins.plugins.amazonecr.AmazonECSRegistryCredential;
import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.Extension;
import hudson.util.Secret;
import java.util.logging.Level;
import java.util.logging.Logger;
import jenkins.authentication.tokens.api.AuthenticationTokenException;
import jenkins.authentication.tokens.api.AuthenticationTokenSource;
import org.jenkinsci.plugins.docker.commons.credentials.DockerRegistryToken;

@Extension
public class AmazonECSRegistryTokenSource
extends AuthenticationTokenSource<DockerRegistryToken, AmazonECSRegistryCredential> {
    private static final Logger LOG = Logger.getLogger(AmazonECSRegistryTokenSource.class.getName());

    public AmazonECSRegistryTokenSource() {
        super(DockerRegistryToken.class, AmazonECSRegistryCredential.class);
    }

    @NonNull
    public DockerRegistryToken convert(@NonNull AmazonECSRegistryCredential credential) throws AuthenticationTokenException {
        LOG.log(Level.FINE, "Converting credential to Docker registry token : {0}", credential.getCredentialsId());
        return new DockerRegistryToken(credential.getEmail(), Secret.toString((Secret)credential.getPassword()));
    }
}

