/*
 * Decompiled with CFR 0.152.
 */
package com.cloudbees.jenkins.plugins.amazonecr;

import com.amazonaws.regions.Regions;
import com.cloudbees.jenkins.plugins.awscredentials.AmazonWebServicesCredentials;
import com.cloudbees.plugins.credentials.CredentialsProvider;
import com.cloudbees.plugins.credentials.CredentialsScope;
import com.cloudbees.plugins.credentials.common.StandardUsernamePasswordCredentials;
import com.cloudbees.plugins.credentials.impl.BaseStandardCredentials;
import edu.umd.cs.findbugs.annotations.CheckForNull;
import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.ProxyConfiguration;
import hudson.model.ItemGroup;
import hudson.security.ACL;
import hudson.util.Secret;
import java.net.URI;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import jenkins.model.Jenkins;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.exception.ExceptionUtils;
import org.springframework.security.core.Authentication;
import software.amazon.awssdk.auth.credentials.AwsCredentialsProvider;
import software.amazon.awssdk.http.SdkHttpClient;
import software.amazon.awssdk.http.apache.ApacheHttpClient;
import software.amazon.awssdk.http.apache.ProxyConfiguration;
import software.amazon.awssdk.regions.Region;
import software.amazon.awssdk.services.ecr.EcrClient;
import software.amazon.awssdk.services.ecr.EcrClientBuilder;
import software.amazon.awssdk.services.ecr.model.AuthorizationData;
import software.amazon.awssdk.services.ecr.model.GetAuthorizationTokenRequest;
import software.amazon.awssdk.services.ecr.model.GetAuthorizationTokenResponse;

public class AmazonECSRegistryCredential
extends BaseStandardCredentials
implements StandardUsernamePasswordCredentials {
    private static final Logger LOG = Logger.getLogger(AmazonECSRegistryCredential.class.getName());
    private final String credentialsId;
    private final String region;
    private final ItemGroup itemGroup;

    public AmazonECSRegistryCredential(CredentialsScope scope, @NonNull String credentialsId, String description, ItemGroup itemGroup) {
        this(scope, credentialsId, Region.US_EAST_1, description, itemGroup);
    }

    @Deprecated
    public AmazonECSRegistryCredential(@CheckForNull CredentialsScope scope, @NonNull String credentialsId, Regions region, String description, ItemGroup itemGroup) {
        this(scope, credentialsId, Region.of((String)region.getName()), description, itemGroup);
    }

    public AmazonECSRegistryCredential(@CheckForNull CredentialsScope scope, @NonNull String credentialsId, Region region, String description, ItemGroup itemGroup) {
        super(scope, "ecr:" + region.id() + ":" + credentialsId, "Amazon ECR Registry:" + (StringUtils.isNotBlank((String)description) ? description : credentialsId) + "-" + String.valueOf(region));
        this.credentialsId = credentialsId;
        this.region = region.id();
        this.itemGroup = itemGroup;
    }

    @NonNull
    public String getCredentialsId() {
        return this.credentialsId;
    }

    @CheckForNull
    public AmazonWebServicesCredentials getCredentials() {
        LOG.log(Level.FINE, "Looking for Amazon web credentials ID: {0} Region: {1}", new Object[]{this.credentialsId, this.region});
        List credentials = CredentialsProvider.lookupCredentialsInItemGroup(AmazonWebServicesCredentials.class, (ItemGroup)this.itemGroup, (Authentication)ACL.SYSTEM2);
        if (LOG.isLoggable(Level.FINEST)) {
            String fullStackTrace = ExceptionUtils.getStackTrace((Throwable)new Throwable());
            LOG.log(Level.FINEST, "Trace: {0}", fullStackTrace);
        }
        if (credentials.isEmpty()) {
            LOG.fine("ID not found");
            return null;
        }
        for (AmazonWebServicesCredentials awsCredentials : credentials) {
            if (!awsCredentials.getId().equals(this.credentialsId)) continue;
            LOG.log(Level.FINE, "ID found {0}", this.credentialsId);
            return awsCredentials;
        }
        LOG.fine("ID not found");
        return null;
    }

    @NonNull
    public String getDescription() {
        String description = super.getDescription();
        LOG.finest(description);
        return description;
    }

    @NonNull
    public Secret getPassword() {
        ProxyConfiguration proxy;
        AmazonWebServicesCredentials credentials = this.getCredentials();
        if (credentials == null) {
            throw new IllegalStateException("Invalid credentials");
        }
        LOG.log(Level.FINE, "Get password for {0} region : {1}", new Object[]{credentials.getDisplayName(), this.region});
        if (LOG.isLoggable(Level.ALL)) {
            String fullStackTrace = ExceptionUtils.getStackTrace((Throwable)new Throwable());
            LOG.log(Level.ALL, "Trace: {0}", fullStackTrace);
        }
        ApacheHttpClient.Builder builder = ApacheHttpClient.builder();
        Jenkins instance = Jenkins.getInstanceOrNull();
        ProxyConfiguration proxyConfiguration = proxy = instance != null ? instance.proxy : null;
        if (proxy != null) {
            List patterns;
            ProxyConfiguration.Builder proxyConfiguration2 = software.amazon.awssdk.http.apache.ProxyConfiguration.builder().endpoint(URI.create(String.format("http://%s:%s", proxy.name, proxy.port)));
            if (proxy.getUserName() != null) {
                proxyConfiguration2.username(proxy.getUserName());
                proxyConfiguration2.password(Secret.toString((Secret)proxy.getSecretPassword()));
            }
            if ((patterns = proxy.getNoProxyHostPatterns()) != null && !patterns.isEmpty()) {
                proxyConfiguration2.nonProxyHosts(patterns.stream().map(Pattern::pattern).collect(Collectors.toSet()));
            }
            builder.proxyConfiguration((software.amazon.awssdk.http.apache.ProxyConfiguration)proxyConfiguration2.build());
        }
        try (EcrClient client = (EcrClient)((EcrClientBuilder)((EcrClientBuilder)((EcrClientBuilder)EcrClient.builder().httpClientBuilder((SdkHttpClient.Builder)builder)).region(Region.of((String)this.region))).credentialsProvider((AwsCredentialsProvider)credentials)).build();){
            GetAuthorizationTokenRequest request = (GetAuthorizationTokenRequest)GetAuthorizationTokenRequest.builder().build();
            GetAuthorizationTokenResponse authorizationToken = client.getAuthorizationToken(request);
            List authorizationData = authorizationToken.authorizationData();
            if (authorizationData == null || authorizationData.isEmpty()) {
                throw new IllegalStateException("Failed to retrieve authorization token for Amazon ECR");
            }
            LOG.fine("Success");
            if (LOG.isLoggable(Level.ALL)) {
                LOG.finest("Auth token: " + String.valueOf(authorizationToken));
                LOG.finest("Request: " + String.valueOf(request));
            }
            Secret secret = Secret.fromString((String)((AuthorizationData)authorizationData.get(0)).authorizationToken());
            return secret;
        }
    }

    @NonNull
    public String getUsername() {
        return "AWS";
    }

    @NonNull
    public String getEmail() {
        return "nobody@example.com";
    }
}

