/*
 * Decompiled with CFR 0.152.
 */
package com.cloudbees.jenkins.plugins.amazonecr;

import com.cloudbees.jenkins.plugins.amazonecr.AmazonECSRegistryCredential;
import com.cloudbees.jenkins.plugins.awscredentials.AmazonWebServicesCredentials;
import com.cloudbees.plugins.credentials.Credentials;
import com.cloudbees.plugins.credentials.CredentialsProvider;
import com.cloudbees.plugins.credentials.domains.DomainRequirement;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import hudson.Extension;
import hudson.model.ItemGroup;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.springframework.security.core.Authentication;
import software.amazon.awssdk.regions.Region;

@Extension
public class AmazonECSRegistryCredentialsProvider
extends CredentialsProvider {
    private static final Logger LOG = Logger.getLogger(AmazonECSRegistryCredentialsProvider.class.getName());

    @NonNull
    public <C extends Credentials> List<C> getCredentialsInItemGroup(@NonNull Class<C> type, @Nullable ItemGroup itemGroup, @Nullable Authentication authentication, @NonNull List<DomainRequirement> domainRequirements) {
        if (!type.isAssignableFrom(AmazonECSRegistryCredential.class)) {
            return Collections.emptyList();
        }
        LinkedList<AmazonECSRegistryCredential> derived = new LinkedList<AmazonECSRegistryCredential>();
        List list = AmazonECSRegistryCredentialsProvider.lookupCredentialsInItemGroup(AmazonWebServicesCredentials.class, (ItemGroup)itemGroup, (Authentication)authentication, domainRequirements);
        for (AmazonWebServicesCredentials credentials : list) {
            LOG.log(Level.FINE, "Resolving Amazon Web Services credentials of scope {0} with id {1} , itemgroup {2}", new Object[]{credentials.getScope(), credentials.getId(), itemGroup});
            derived.add(new AmazonECSRegistryCredential(credentials.getScope(), credentials.getId(), credentials.getDescription(), itemGroup));
            for (Region region : Region.regions()) {
                LOG.log(Level.FINE, "Resolving Amazon Web Services credentials of scope {0} with id {1} and region {2}", new Object[]{credentials.getScope(), credentials.getId(), region});
                derived.add(new AmazonECSRegistryCredential(credentials.getScope(), credentials.getId(), region, credentials.getDescription(), itemGroup));
            }
        }
        return derived;
    }
}

