/*
 * Decompiled with CFR 0.152.
 */
package com.cloudbees.groovy.cps;

import com.cloudbees.groovy.cps.Continuation;
import com.cloudbees.groovy.cps.CpsTransformer;
import com.cloudbees.groovy.cps.ObjectInputStreamWithLoader;
import com.cloudbees.groovy.cps.SerializableScript;
import com.cloudbees.groovy.cps.impl.CpsCallableInvocation;
import groovy.lang.Binding;
import groovy.lang.GroovyShell;
import groovy.lang.Script;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectOutputStream;
import java.util.concurrent.atomic.AtomicReference;
import org.codehaus.groovy.control.CompilerConfiguration;
import org.codehaus.groovy.control.customizers.CompilationCustomizer;
import org.codehaus.groovy.control.customizers.ImportCustomizer;
import org.hamcrest.CoreMatchers;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.rules.ErrorCollector;
import org.kohsuke.groovy.sandbox.impl.GroovyCallSiteSelector;

public abstract class AbstractGroovyCpsTest {
    @Rule
    public ErrorCollector ec = new ErrorCollector();
    private GroovyShell csh;
    private GroovyShell sh;
    private Binding binding = new Binding();

    @Before
    public void setUp() {
        ImportCustomizer imports = new ImportCustomizer();
        imports.addStarImports(new String[]{"com.cloudbees.groovy.cps", this.getClass().getPackage().getName()});
        CompilerConfiguration cc = new CompilerConfiguration();
        cc.addCompilationCustomizers(new CompilationCustomizer[]{imports});
        cc.addCompilationCustomizers(new CompilationCustomizer[]{this.createCpsTransformer()});
        cc.setScriptBaseClass(SerializableScript.class.getName());
        this.csh = new GroovyShell(this.binding, cc);
        cc = new CompilerConfiguration();
        cc.addCompilationCustomizers(new CompilationCustomizer[]{imports});
        this.sh = new GroovyShell(this.binding, cc);
    }

    public GroovyShell getCsh() {
        return this.csh;
    }

    public GroovyShell getSh() {
        return this.sh;
    }

    public Binding getBinding() {
        return this.binding;
    }

    protected CpsTransformer createCpsTransformer() {
        return new CpsTransformer();
    }

    protected void eval(String script, Object expectedResult, ExceptionHandler handler) {
        try {
            Object actual = this.sh.evaluate(script);
            String actualType = GroovyCallSiteSelector.getName((Object)actual);
            String expectedType = GroovyCallSiteSelector.getName((Object)expectedResult);
            this.ec.checkThat("Non-CPS-transformed result (" + actualType + ") does not match expected result (" + expectedType + ")", actual, CoreMatchers.equalTo((Object)expectedResult));
        }
        catch (Throwable t) {
            this.ec.checkSucceeds(() -> {
                handler.handleException(t);
                return null;
            });
        }
    }

    protected void evalCps(String script, Object expectedResult, ExceptionHandler handler) {
        try {
            Object actual = this.parseCps(script).invoke(null, null, Continuation.HALT).run(10000).replay();
            String actualType = GroovyCallSiteSelector.getName((Object)actual);
            String expectedType = GroovyCallSiteSelector.getName((Object)expectedResult);
            this.ec.checkThat("Non-CPS-transformed result (" + actualType + ") does not match expected result (" + expectedType + ")", actual, CoreMatchers.equalTo((Object)expectedResult));
        }
        catch (Throwable t) {
            this.ec.checkSucceeds(() -> {
                handler.handleException(t);
                return null;
            });
        }
    }

    public void assertEvaluate(Object expectedReturnValue, String script) {
        this.evalCps(script, expectedReturnValue, e -> {
            throw new RuntimeException("Failed to evaluate CPS-transformed script: " + script, e);
        });
        this.eval(script, expectedReturnValue, e -> {
            throw new RuntimeException("Failed to evaluate non-CPS-transformed script: " + script, e);
        });
    }

    public void assertFailsWithSameException(String expression) {
        AtomicReference cpsException = new AtomicReference();
        this.evalCps(expression, ShouldFail.class, cpsException::set);
        AtomicReference nonCpsException = new AtomicReference();
        this.eval(expression, ShouldFail.class, nonCpsException::set);
        if (cpsException.get() == null || nonCpsException.get() == null) {
            return;
        }
        this.ec.checkThat("CPS-transformed and non-CPS-transformed exceptions should have the same type", ((Throwable)nonCpsException.get()).getClass(), CoreMatchers.equalTo(((Throwable)cpsException.get()).getClass()));
        this.ec.checkThat("CPS-transformed and non-CPS-transformed exceptions should have the same message", (Object)((Throwable)nonCpsException.get()).getMessage(), CoreMatchers.equalTo((Object)((Throwable)cpsException.get()).getMessage()));
    }

    public Object evalCPSonly(String script) throws Throwable {
        return this.parseCps(script).invoke(null, null, Continuation.HALT).run(10000).replay();
    }

    public CpsCallableInvocation parseCps(String script) {
        Script s = this.csh.parse(script);
        try {
            s.run();
            Assert.fail((String)"Expecting CPS transformation");
        }
        catch (CpsCallableInvocation inv) {
            return inv;
        }
        throw new AssertionError((Object)"Expecting CpsCallableInvocation");
    }

    public <T> T roundtripSerialization(T cx) throws ClassNotFoundException, IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        new ObjectOutputStream(baos).writeObject(cx);
        ObjectInputStreamWithLoader ois = new ObjectInputStreamWithLoader((InputStream)new ByteArrayInputStream(baos.toByteArray()), (ClassLoader)this.csh.getClassLoader());
        return (T)ois.readObject();
    }

    @FunctionalInterface
    public static interface ExceptionHandler {
        public void handleException(Throwable var1) throws Exception;
    }

    public static final class ShouldFail {
    }
}

