/*
 * Decompiled with CFR 0.152.
 */
package com.cloudbees.groovy.cps;

import com.cloudbees.groovy.cps.AbstractGroovyCpsTest;
import com.cloudbees.groovy.cps.Continuable;
import com.cloudbees.groovy.cps.Continuation;
import com.cloudbees.groovy.cps.impl.CpsCallableInvocation;
import groovy.lang.IntRange;
import java.io.File;
import java.math.BigDecimal;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.codehaus.groovy.control.MultipleCompilationErrorsException;
import org.codehaus.groovy.runtime.InvokerHelper;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.Assert;
import org.junit.Ignore;
import org.junit.Test;

public class CpsTransformerTest
extends AbstractGroovyCpsTest {
    @Test
    public void helloWorld() throws Throwable {
        this.assertEvaluate(11, "'hello world'.length()");
    }

    @Test
    public void comparison() throws Throwable {
        for (int i : new int[]{1, 2, 3}) {
            for (int j : new int[]{1, 2, 3}) {
                this.assertEvaluate(i < j, i + " < " + j);
                this.assertEvaluate(i <= j, i + " <= " + j);
                this.assertEvaluate(i > j, i + " > " + j);
                this.assertEvaluate(i >= j, i + " >=" + j);
            }
        }
    }

    @Test
    public void forInLoop() throws Throwable {
        this.assertEvaluate(15, "x=0; for (i in [1,2,3,4,5]) x+=i; return x;");
    }

    @Test
    public void variableAssignment() throws Throwable {
        this.assertEvaluate(5, "x=3; x+=2; return x;");
    }

    @Test
    public void localVariable() throws Throwable {
        this.assertEvaluate(5, "int x=3; x+=2; return x;");
    }

    @Test
    public void increment() throws Throwable {
        this.assertEvaluate("2.0.2", "x=0;\ny = x++;\nz = ++x;\nreturn x+'.'+y+'.'+z;\n");
    }

    @Test
    public void decrement() throws Throwable {
        this.assertEvaluate("3.5.3", "x=5;\ny = x--;\nz = --x;\nreturn x+'.'+y+'.'+z;\n");
    }

    @Test
    public void break_() throws Throwable {
        this.assertEvaluate(0, "x=0;\nint i=0;\nfor (i=0; i<5; i+=1) {\n    break;\n    x+=1;\n}\nreturn i+x;\n");
    }

    @Test
    public void globalBreak_() throws Throwable {
        this.assertEvaluate("0.0.0", "x=0;\nint i=0;\nint j=0;\nI:\nfor (i=0; i<5; i+=1) {\n    J:\n    for (j=0; j<5; j+=1) {\n      break I;\n      x+=1;\n    }\n    x+=1;\n}\nreturn i+'.'+j+'.'+x;\n");
    }

    @Test
    public void functionCall() throws Throwable {
        this.assertEvaluate(3, "int i=1;\ni.plus(2)");
    }

    @Test
    public void functionCall0arg() throws Throwable {
        this.assertEvaluate("123", "123.toString()");
    }

    @Test
    public void constructorCall() throws Throwable {
        this.assertEvaluate("abcdef", "new String('abc'+'def')");
    }

    @Test
    public void constructorCall0arg() throws Throwable {
        this.assertEvaluate("", "new String()");
    }

    @Test
    public void constructorList() throws Throwable {
        this.assertEvaluate(new File("/parent", "name"), "File f = ['/parent', 'name']\nreturn f");
        this.assertEvaluate(new File("/parent", "name"), "def close = {String parent, String name -> [parent, name] as File}\nreturn close('/parent', 'name')\n");
    }

    @Test
    public void workflowCallingWorkflow() throws Throwable {
        this.assertEvaluate(55, "def fib(int x) {\n  if (x==0)     return 0;\n  if (x==1)     return 1;\n  x = fib(x-1)+fib(x-2);\n  return x;\n}\nfib(10);\n");
    }

    @Test
    public void typeCoercion() throws Throwable {
        this.assertEvaluate(Locale.getAvailableLocales(), "interface I {\n    Locale[] getAvailableLocales()\n}\ntry {\n    (Locale as I).getAvailableLocales()\n} catch (e) {\n    e.toString()\n}\n");
    }

    @Test
    public void exceptionFromNonCpsCodeShouldBeCaughtByCatchBlockInCpsCode() throws Throwable {
        String message = (String)this.evalCPSonly("def foo() {\n  'abc'.substring(5);\n  return 'fail';\n}\ntry {\n  return foo();\n} catch(StringIndexOutOfBoundsException e) {\n  return e.message;\n}\n");
        MatcherAssert.assertThat((Object)message, (Matcher)CoreMatchers.anyOf((Matcher[])new Matcher[]{CoreMatchers.equalTo((Object)"String index out of range: -2"), CoreMatchers.equalTo((Object)"begin 5, end 3, length 3"), CoreMatchers.equalTo((Object)"Range [5, 3) out of bounds for length 3")}));
    }

    @Test
    public void whileLoop() throws Throwable {
        this.assertEvaluate(1, "int x=1;\nwhile (false) {\n    x++;\n}\nreturn x;\n");
    }

    @Test
    public void whileLoop5() throws Throwable {
        this.assertEvaluate(5, "int x=1;\nwhile (x<5) {\n    x++;\n}\nreturn x;\n");
    }

    @Test
    @Ignore(value="Groovy 2.x does not support do-while loops")
    public void doWhileLoop() throws Throwable {
        this.assertEvaluate(2, "int x=1;\ndo {\n    x++;\n} while (false);\nreturn x;\n");
    }

    @Test
    @Ignore(value="Groovy 2.x does not support do-while loops")
    public void dowhileLoop5() throws Throwable {
        this.assertEvaluate(5, "int x=1;\ndo {\n    x++;\n} while (x<5);\nreturn x;\n");
    }

    @Test
    public void helloClosure() throws Throwable {
        this.assertEvaluate(5, "x = { -> 5 }\nreturn x();\n");
    }

    @Test
    public void closureShouldCaptureLiveVariables() throws Throwable {
        this.assertEvaluate("0.3.5", "def c1,c2;\n{ ->\n    def x = 0;\n    c1 = { return x; }\n    c2 = { v -> x=v; }\n}();\nr = ''+c1();\nc2(3);\nr += '.'+c1();\nc2(5);\nr += '.'+c1();\nreturn r;\n");
    }

    @Test
    public void closureHasImplicitItVariable() throws Throwable {
        this.assertEvaluate(4, "c = { it+1 }\nc(3);\n");
    }

    @Test
    public void closureDelegateProperty() throws Throwable {
        this.assertEvaluate("3-xyz-xyz-true", "def config(c) {\n    def map = [:];\n    c.resolveStrategy = Closure.DELEGATE_FIRST;\n    c.delegate = map;\n    c();\n    return map;\n}\ndef x = config {\n    foo = 3;\n    bar = 'xyz';\n    zot = bar;\n    fog = containsKey('foo');\n}\nreturn [x.foo, x.bar, x.zot, x.fog].join('-');\n");
    }

    @Test
    public void serialization() throws Throwable {
        CpsCallableInvocation s = this.parseCps("def plus3(int x) {\n    return x+3;\n}\nfor (int x=0; x<10; x++) {\n    try {\n        while (false)\n            ;\n    } catch(Exception e) {\n        ;\n    }\n}\n1+plus3(3*2)\n");
        Continuable cx = new Continuable(s.invoke(null, null, Continuation.HALT));
        cx = this.roundtripSerialization(cx);
        Assert.assertEquals((Object)10, (Object)cx.run(null));
    }

    @Test
    public void assertion() throws Throwable {
        this.assertEvaluate(3, "assert true\nassert true : 'message'\nreturn 3;\n");
        this.evalCps("assert 1+2 == ((4));", AbstractGroovyCpsTest.ShouldFail.class, t -> {
            this.ec.checkThat((Object)t, CoreMatchers.instanceOf(AssertionError.class));
            this.ec.checkThat((Object)t.getMessage(), CoreMatchers.containsString((String)"1+2 == ((4))"));
        });
        this.evalCps("assert (1+2) == 4 : 'with message';", AbstractGroovyCpsTest.ShouldFail.class, t -> {
            this.ec.checkThat((Object)t, CoreMatchers.instanceOf(AssertionError.class));
            this.ec.checkThat((Object)t.getMessage(), CoreMatchers.containsString((String)"with message. Expression: assert (1+2) == 4 : 'with message'"));
        });
    }

    @Test
    public void unaryOps() throws Throwable {
        this.assertEvaluate(0, "def x = 5;\ndef y = -x;\ndef z = +x;\nreturn y+z;\n");
    }

    @Test
    public void not() throws Throwable {
        this.assertEvaluate("y=false,z=true", "def x = true;\ndef y = !x;\ndef z = !y;\nreturn 'y='+y+',z='+z;\n");
    }

    @Test
    public void bitwiseNegative() throws Throwable {
        this.assertEvaluate(-33, "int x = 32;\nreturn ~x;\n");
    }

    @Test
    public void gstring() throws Throwable {
        this.assertEvaluate("hello 4=foo", "def x = 'foo';\nreturn \"hello ${1+3}=${x}\".toString()\n");
    }

    @Test
    public void gstringWithStringWriterClosure() throws Throwable {
        String script = "String text = 'Foobar';\nString result = /${ w -> w << text}/.toString();\nreturn result;\n";
        this.assertEvaluate("Foobar", script);
    }

    @Test
    public void ternaryOp() throws Throwable {
        this.assertEvaluate(5, "return true ? 5 : null.makeCall();");
    }

    @Test
    public void ternaryOp2() throws Throwable {
        this.assertEvaluate("zot", "false ? bogus.noSuchCall() : 'zot'");
    }

    @Test
    public void ternaryOp3() throws Throwable {
        this.assertEvaluate(List.of("ok", Integer.valueOf(2)), "def x = 'ok'; def y = null; [x ?: 1, y ?: 2]");
    }

    @Test
    public void elvisOp() throws Throwable {
        this.assertEvaluate(1, "def x=0; return ++x ?: -1");
        this.assertEvaluate(-1, "def x=0; return x++ ?: -1");
    }

    @Test
    public void logicalOp() throws Throwable {
        this.assertEvaluate(false, "true && (false || false)");
        this.assertEvaluate(true, "true && (true || false)");
        this.assertEvaluate(false, "false && (true || false)");
        this.assertEvaluate(true, "false || 'rhs of || must be cast to boolean'");
        this.assertEvaluate(true, "true && 'rhs of && must be cast to boolean'");
        this.assertEvaluate("[true, false, true, true] [1, 0, 0, 4]", "x = [0, 0, 0, 0]\ndef set(index) {\n    x[index - 1] = index\n    true\n}\ndef r = [\n    true  && set(1),\n    false && set(2),\n    true  || set(3),\n    false || set(4)\n]\n\"${r} ${x}\".toString()\n");
    }

    @Test
    public void range() throws Throwable {
        this.assertEvaluate(new IntRange(true, 0, 5), "def x=5; return (0..x)");
        this.assertEvaluate(new IntRange(false, 0, 5), "def x=5; return (0..<x)");
    }

    @Test
    public void minusEqual() throws Throwable {
        this.assertEvaluate(2, "def x=5; x-=3; return x;");
    }

    @Test
    public void multiplyEqual() throws Throwable {
        this.assertEvaluate(15, "def x=5; x*=3; return x;");
    }

    @Test
    public void divEqual() throws Throwable {
        this.assertEvaluate(new BigDecimal("10"), "def x=50; x/=5; return x;");
    }

    @Test
    public void instanceOfKeyword() throws Throwable {
        this.assertEvaluate(false, "null instanceof String");
        this.assertEvaluate(true, "3 instanceof Integer");
        this.assertEvaluate(true, "new RuntimeException() instanceof Exception");
        this.assertEvaluate(true, "'12345' instanceof String");
    }

    @Test
    public void safeNavigation() throws Throwable {
        this.assertEvaluate(null, "def x = null; x?.stuff()");
        this.assertEvaluate(null, "def x = null; x?.stuff");
        this.assertEvaluate(null, "def x = null; x?.@stuff");
    }

    @Test
    public void compoundBitwiseAssignment() throws Throwable {
        for (int x : new int[]{0, 1, 2, 3, 4}) {
            for (int y : new int[]{0, 1, 2, 3, 4}) {
                this.assertEvaluate(x & y, "def x=" + x + "; x&=" + y + "; return x;");
                this.assertEvaluate(x | y, "def x=" + x + "; x|=" + y + "; return x;");
                this.assertEvaluate(x ^ y, "def x=" + x + "; x^=" + y + "; return x;");
            }
        }
    }

    @Test
    public void attributeSet() throws Throwable {
        this.assertEvaluate(1, "new java.awt.Point(1,2).@x");
    }

    @Test
    public void attributeGet() throws Throwable {
        this.assertEvaluate(6, "def p = new java.awt.Point(1,2); p.@x+=5; p.@x");
    }

    @Test
    public void multidimensionalArrayInstantiation() throws Throwable {
        this.assertEvaluate(12, "def x = new int[3][4];\nint z = 0;\nfor (int i=0; i<x.length; i++)\n    z += x[i].length;\nreturn z;\n");
    }

    @Test
    public void arrayAccess() throws Throwable {
        this.assertEvaluate(7, "def x = new int[3]; x[0]=1; x[1]=x[0]+2; x[1]+=4; return x[1]");
    }

    @Test
    public void bitShift() throws Throwable {
        this.assertEvaluate(24, "3<<3");
        this.assertEvaluate(24, "x=3; x<<=3; x");
        this.assertEvaluate(2, "5 >> 1");
        this.assertEvaluate(2, "x=5; x>>=1; x");
        this.assertEvaluate(Integer.MAX_VALUE, "-1>>>1");
        this.assertEvaluate(Integer.MAX_VALUE, "x=-1; x>>>=1; x");
        this.assertEvaluate(List.of("hello", "world"), "x=[]; x<<'hello'; x<<'world'; x");
    }

    @Test
    public void inOperator() throws Throwable {
        this.assertEvaluate(true, "3 in [1,2,3]");
        this.assertEvaluate(true, "'ascii' in String.class");
        this.assertEvaluate(false, "6 in [1,2,3]");
        this.assertEvaluate(false, "'ascii' in URL.class");
    }

    @Test
    public void regexpOperator() throws Throwable {
        this.assertEvaluate(true, "('cheesecheese' =~ 'cheese') as boolean");
        this.assertEvaluate(true, "('cheesecheese' =~ /cheese/) as boolean");
        this.assertEvaluate(false, "('cheese' =~ /ham/) as boolean");
        this.assertEvaluate(true, "('2009' ==~ /\\d+/) as boolean");
        this.assertEvaluate(false, "('holla' ==~ /\\d+/) as boolean");
    }

    @Test
    public void arrayPassedToMethod() throws Throwable {
        this.assertEvaluate(4, "def m(x) {x.size()}; def a = [1, 2]; a.size() + m(a)");
        this.assertEvaluate(4, "def m(x) {x.size()}; def a = [1, 2].toArray(); a.length + m(Arrays.asList(a))");
        this.assertEvaluate(4, "@NonCPS def m(x) {x.length}; def a = [1, 2].toArray(); a.length + m(a)");
        this.assertEvaluate(4, "def m(x) {x.length}; def a = [1, 2].toArray(); a.length + m(a)");
    }

    @Test
    public void varArgs() throws Throwable {
        this.assertEvaluate(1, "def fn(String... args) { args.size() }; fn('one string')");
    }

    @Test
    public void currying() throws Throwable {
        this.assertEvaluate("foofoo", "def nCopies = { int n, String str -> str*n }; def twice=nCopies.curry(2); twice('foo')");
    }

    @Test
    public void ncurrying_native_closure() throws Throwable {
        this.assertEvaluate(List.of(Integer.valueOf(-3), Integer.valueOf(2)), "@NonCPS\ndef makeNativeClosure() {\n    Collections.&binarySearch\n}\ndef catSearcher = makeNativeClosure().ncurry(1,'cat')\nreturn [\n    catSearcher(['ant','bee','dog']),\n    catSearcher(['ant','bee','cat'])\n]\n");
    }

    @Test
    public void fieldDirect() throws Throwable {
        this.assertEvaluate(33, "class C {private int x = 33}; new C().x");
    }

    @Test
    public void fieldViaGetter() throws Throwable {
        this.assertEvaluate(66, "class C {private int x = 33; int getX() {2 * this.@x}}; new C().x");
        this.assertEvaluate(66, "class C {private int x = 33; int getX() {2 * x}}; new C().x");
    }

    @Ignore(value="Currently throws StackOverflowError")
    @Test
    public void fieldViaGetterWithThis() throws Throwable {
        this.assertEvaluate(66, "class C {private int x = 33; int getX() {2 * this.x}}; new C().x");
    }

    @Test
    public void fieldViaSetter() throws Throwable {
        this.assertEvaluate(22, "class C {private int x = 0; int getX() {2 * x}; void setX(int x) {this.@x = x / 3}}; C c = new C(); c.x = 33; c.x");
        this.assertEvaluate(22, "class C {private int x = 0; int getX() {2 * x}; void setX(int x) {this.x = x / 3}}; C c = new C(); c.x = 33; c.x");
    }

    @Test
    public void nonField() throws Throwable {
        this.assertEvaluate(new BigDecimal("22"), "class C extends HashMap {def read() {x * 2}; def write(x) {this.x = x / 3}}; C c = new C(); c.write(33); c.read()");
    }

    @Test
    public void method_pointer() throws Throwable {
        this.assertEvaluate(List.of(Integer.valueOf(3), Integer.valueOf(7)), "def add = CpsTransformerTest.&add\nreturn [ add(1,2), add(3,4) ]\n");
        this.assertEvaluate(List.of(Boolean.valueOf(true), Boolean.valueOf(false)), "def contains = 'foobar'.&contains\nreturn [ contains('oo'), contains('xyz') ]\n");
        this.assertEvaluate(List.of(Integer.valueOf(1101), Integer.valueOf(10011)), "class X {\n    int z;\n    X(int z) { this.z = z; }\n    int add(int x, int y) { x+y+z }\n}\ndef adder = (new X(1)).&add;\ndef plus1 = adder.curry(10)\nreturn [ adder(100,1000), plus1(10000) ]\n");
    }

    public static int add(int a, int b) {
        return a + b;
    }

    @Test
    public void interfaceDeclaration() throws Throwable {
        this.assertEvaluate(true, "interface Strategy {\n    Closure process(Object event)\n}\nreturn true\n");
    }

    @Test
    public void emptyInterfaceDeclaration() throws Throwable {
        this.assertEvaluate(true, "interface Empty {}\nreturn true\n");
    }

    @Ignore
    @Test
    public void overloadedMethods() throws Throwable {
        this.assertEvaluate("iterable", "public String bar(List<String> l) {\n    return bar((Iterable)l)\n}\npublic String bar(Iterable<String> l) {\n    return 'iterable'\n}\nList<String> s = ['a', 'b']\nreturn bar(s)\n");
    }

    @Ignore
    @Test
    public void overloadedMethodsWithRawTypes() throws Throwable {
        this.assertEvaluate("iterable", "public String bar(List l) {\n    return bar((Iterable)l)\n}\npublic String bar(Iterable l) {\n    return 'iterable'\n}\nList s = ['a', 'b']\nreturn bar(s)\n");
    }

    @Ignore
    @Test
    public void overloadedStaticMethods() throws Throwable {
        this.assertEvaluate("iterable", "public static String bar(List l) {\n    return bar((Iterable)l)\n}\npublic static String bar(Iterable l) {\n    return 'iterable'\n}\nList s = ['a', 'b']\nreturn bar(s)\n");
    }

    @Test
    public void superClass() throws Throwable {
        this.assertEvaluate("xbase", "class Foo extends CpsTransformerTest.Base {\n    public String toString() {\n        return 'x'+super.toString();\n    }\n}\nnew Foo().toString();\n");
    }

    @Test
    public void transformedSuperClass() throws Throwable {
        this.assertEvaluate("ybase", "class Foo extends CpsTransformerTest.Base {\n    public String other() {\n        return 'base'\n    }\n}\nclass Bar extends Foo {\n    public String other() {\n        return 'y'+super.other()\n    }\n}\nnew Bar().other();\n");
    }

    @Test
    public void transformedSuperSuperClass() throws Throwable {
        this.assertEvaluate("zybase", "class Foo extends CpsTransformerTest.Base {\n    public String other() {\n        return 'base'\n    }\n}\nclass Bar extends Foo {\n    public String other() {\n        return 'y'+super.other()\n    }\n}\nclass Baz extends Bar {\n    public String other() {\n        return 'z'+super.other()\n    }\n}\nnew Baz().other();\n");
    }

    @Test
    public void abstractMethod() throws Throwable {
        this.assertEvaluate(123, "abstract class Foo {\n    abstract int val()\n}\nFoo foo = new Foo() {int val() {123}}\nfoo.val()\n");
    }

    @Test
    @Ignore
    public void rehydrateClosure() throws Throwable {
        this.assertEvaluate("from Script instance", "class MyStrategy {\n    Closure<String> process() {\n        return {\n            speak()\n        }\n    }\n}\nString speak() {\n    'from Script instance'\n}\nClosure<String> closure = new MyStrategy().process()\nclosure.rehydrate(this, this, this).call()\n");
    }

    @Test
    @Ignore(value="cannot easily be supported")
    public void category() throws Throwable {
        this.assertEvaluate("FOO", "class BarCategory {\n    static String up(String text) {\n        text.toUpperCase()\n    }\n}\nreturn use(BarCategory) {\n    'foo'.up()\n};\n");
    }

    @Test
    public void lexicalScope() throws Throwable {
        this.assertEvaluate(List.of(Integer.valueOf(1), Integer.valueOf(1)), "def a = [id: 'a', count: 0]\ndef b = [id: 'b', count: 0]\ndef toRun = [a, b].collect { thing -> return { thing.count = thing.count + 1 } }\ntoRun.each { arg -> arg() }\nreturn [a.count, b.count]\n");
    }

    @Test
    public void methodPointer() throws Throwable {
        this.assertEvaluate("baseClass", "def b = new CpsTransformerTest.Base()\nreturn (b.&toString)() + (String.getClass().&getSimpleName)()\n");
    }

    @Test
    public void allClassesSerializable() throws Throwable {
        this.evalCPSonly("class C {}; def c = new C(); assert c instanceof Serializable");
        this.evalCPSonly("class C implements Serializable {}; def c = new C(); assert c instanceof Serializable");
        Assert.assertTrue((boolean)((Boolean)this.evalCPSonly("@NonCPS\ndef anonymousClass() {\n  def r = new Runnable() {\n    @Override\n    public void run() {}\n  }\n  return r instanceof Serializable\n}\nreturn anonymousClass()\n")));
    }

    @Test
    public void multipleAssignment() throws Throwable {
        this.assertEvaluate("firstsecondthirdfourth", "def (a, b) = ['first', 'second']\ndef c, d\n(c, d) = ['third', 'fourth']\nreturn a + b + c + d\n");
    }

    @Test
    public void nonArrayLikeMultipleAssignment() throws Throwable {
        this.assertEvaluate(true, "try {\n  def (a,b) = 4\n  return false\n} catch (Exception e) {\n  return e instanceof MissingMethodException\n}\n");
    }

    @Test
    public void arrayLikeMultipleAssignment() throws Throwable {
        this.assertEvaluate("wh", "def (a,b) = 'what'\nreturn a + b\n");
    }

    @Test
    public void mismatchedSizeMultipleAssignment() throws Throwable {
        this.assertEvaluate("first second fourth null", "def (a, b) = ['first', 'second', 'third']\ndef (c, d) = ['fourth']\nreturn [a, b, c, d].join(' ')\n");
    }

    @Test
    public void excessiveListElements() throws Throwable {
        String s1 = IntStream.range(0, 250).boxed().map(Object::toString).collect(Collectors.joining(",\n"));
        this.assertEvaluate(250, "def b = [" + s1 + "]\nreturn b.size()\n");
        String s2 = IntStream.range(0, 251).boxed().map(Object::toString).collect(Collectors.joining(",\n"));
        this.evalCps("def b = [" + s2 + "]\nreturn b.size()\n", AbstractGroovyCpsTest.ShouldFail.class, t -> {
            MatcherAssert.assertThat((Object)t, (Matcher)CoreMatchers.instanceOf(MultipleCompilationErrorsException.class));
            MatcherAssert.assertThat((Object)t.getMessage(), (Matcher)CoreMatchers.containsString((String)"List expressions can only contain up to 250 elements"));
        });
    }

    @Test
    public void excessiveMapElements() throws Throwable {
        String s1 = IntStream.range(0, 125).boxed().map(i -> i + ":" + i).collect(Collectors.joining(",\n"));
        this.assertEvaluate(125, "def b = [" + s1 + "]\nreturn b.size()\n");
        String s2 = IntStream.range(0, 126).boxed().map(i -> i + ":" + i).collect(Collectors.joining(",\n"));
        this.evalCps("def b = [" + s2 + "]\nreturn b.size()\n", AbstractGroovyCpsTest.ShouldFail.class, t -> {
            MatcherAssert.assertThat((Object)t, (Matcher)CoreMatchers.instanceOf(MultipleCompilationErrorsException.class));
            MatcherAssert.assertThat((Object)t.getMessage(), (Matcher)CoreMatchers.containsString((String)"Map expressions can only contain up to 125 entries"));
        });
    }

    @Test
    public void multipleAssignmentRunsMethodOnce() throws Throwable {
        this.assertEvaluate("firstsecondthirdfourth", "alreadyRun = false\ndef getAandB() {\n  if (!alreadyRun) {\n    alreadyRun = true\n    return ['first', 'second']\n  } else {\n    return ['bad', 'worse']\n  }\n}\ndef (a, b) = getAandB()\ndef c, d\n(c, d) = ['third', 'fourth']\nreturn a + b + c + d\n");
    }

    @Test
    public void mapEntryInBadContext() throws Throwable {
        this.evalCps("return [[a: 'a'], [b: 'b'][c: 'c']]", AbstractGroovyCpsTest.ShouldFail.class, e -> {
            this.ec.checkThat((Object)e, CoreMatchers.instanceOf(MultipleCompilationErrorsException.class));
            this.ec.checkThat((Object)e.getMessage(), CoreMatchers.containsString((String)"Unsupported map entry expression for CPS transformation in this context"));
        });
    }

    @Test
    public void spreadMethodCall() throws Throwable {
        this.evalCps("return ['a', 'b', 'c']*.hashCode()", AbstractGroovyCpsTest.ShouldFail.class, e -> {
            this.ec.checkThat((Object)e, CoreMatchers.instanceOf(MultipleCompilationErrorsException.class));
            this.ec.checkThat((Object)e.getMessage(), CoreMatchers.containsString((String)"spread not yet supported for CPS transformation"));
        });
    }

    @Test
    public void synchronizedStatement() throws Throwable {
        this.evalCps("synchronized(this) { return 1 }", AbstractGroovyCpsTest.ShouldFail.class, e -> {
            this.ec.checkThat((Object)e, CoreMatchers.instanceOf(MultipleCompilationErrorsException.class));
            this.ec.checkThat((Object)e.getMessage(), CoreMatchers.containsString((String)"synchronized is unsupported for CPS transformation"));
        });
    }

    @Test
    public void spreadExpression() throws Throwable {
        String[] declarations;
        for (String decl : declarations = new String[]{"def", "Object[]", "int[]"}) {
            this.assertEvaluate(List.of(Integer.valueOf(1), Integer.valueOf(2), Integer.valueOf(3), Integer.valueOf(4), Integer.valueOf(5)), decl + " x = [1, 2, 3]\nreturn [*x, 4, 5]\n");
            this.assertEvaluate(List.of(Integer.valueOf(4), Integer.valueOf(1), Integer.valueOf(2), Integer.valueOf(3), Integer.valueOf(5)), decl + " x = [1, 2, 3]\nreturn [4, *x, 5]\n");
            this.assertEvaluate(List.of(Integer.valueOf(4), Integer.valueOf(5), Integer.valueOf(1), Integer.valueOf(2), Integer.valueOf(3)), decl + " x = [1, 2, 3]\nreturn [4, 5, *x]\n");
            this.assertEvaluate(List.of(Integer.valueOf(1), Integer.valueOf(2), Integer.valueOf(3)), decl + " x = [1, 2, 3]\nreturn [*x]\n");
            this.assertEvaluate(List.of(Integer.valueOf(1), Integer.valueOf(2), Integer.valueOf(3), Integer.valueOf(4), Integer.valueOf(5), Integer.valueOf(6), Integer.valueOf(7)), decl + " x = [2, 3]\n" + decl + " y = [5, 6]\nreturn [1, *x, 4, *y, 7]\n");
        }
        this.assertEvaluate(Collections.singletonList(null), "def x = null\nreturn [*x]\n");
        this.assertFailsWithSameException("def x = 1\nreturn *x\n");
    }

    @Test
    public void spreadMethodCallArguments() throws Throwable {
        String[] declarations;
        for (String decl : declarations = new String[]{"def", "Object[]", "int[]"}) {
            this.assertEvaluate(List.of(Integer.valueOf(1), Integer.valueOf(2), Integer.valueOf(3)), decl + " x = [1, 2, 3]\ndef id(a, b, c) { [a, b, c] }\nreturn id(*x)\n");
            this.assertEvaluate(List.of(Integer.valueOf(1), Integer.valueOf(2), Integer.valueOf(3)), decl + " x = [2, 3]\ndef id(a, b, c) { [a, b, c] }\nreturn id(1, *x)\n");
            this.assertEvaluate(List.of(Integer.valueOf(1), Integer.valueOf(2), Integer.valueOf(3)), decl + " x = [1, 2]\ndef id(a, b, c) { [a, b, c] }\nreturn id(*x, 3)\n");
            this.assertEvaluate(List.of(Integer.valueOf(1), Integer.valueOf(2), Integer.valueOf(3)), decl + " x = [2]\ndef id(a, b, c) { [a, b, c] }\nreturn id(1, *x, 3)\n");
        }
        this.assertEvaluate(Arrays.asList(1, null, 3), "def x = null\ndef id(a, b, c) { [a, b, c] }\nreturn id(1, *x, 3)\n");
    }

    @Test
    public void spreadMapExpression() throws Throwable {
        this.assertEvaluate(InvokerHelper.createMap((Object[])new Object[]{"a", 1, "b", 2, "c", 3, "d", 4, "e", 5}), "def x = [a: 1, b: 2, c: 3]\nreturn [*:x, d: 4, e: 5]\n");
        this.assertEvaluate(InvokerHelper.createMap((Object[])new Object[]{"d", 4, "a", 1, "b", 2, "c", 3, "e", 5}), "def x = [a: 1, b: 2, c: 3]\nreturn [d: 4, *:x, e: 5]\n");
        this.assertEvaluate(InvokerHelper.createMap((Object[])new Object[]{"d", 4, "e", 5, "a", 1, "b", 2, "c", 3, "e", 5}), "def x = [a: 1, b: 2, c: 3]\nreturn [d: 4, e: 5, *:x]\n");
        this.assertEvaluate(InvokerHelper.createMap((Object[])new Object[]{"a", 1, "b", 2, "c", -1}), "def x = [a: 1, b: 2, c: 3]\nreturn [c: 4, *:x, c: -1]\n");
        this.assertEvaluate(InvokerHelper.createMap((Object[])new Object[]{"a", 1, "b", 2, "c", 3}), "def x = [a: 1, b: 2, c: 3]\nreturn [*:x]\n");
        this.assertEvaluate(InvokerHelper.createMap((Object[])new Object[]{"a", 1, "b", 2, "c", 3, "d", 4, "e", 5, "f", 6, "g", 7}), "def x = [b: 2, c: 3]\ndef y = [e: 5, f: 6]\nreturn [a: 1, *:x, d: 4, *:y, g: 7]\n");
        this.assertEvaluate(Map.of("a", 1), "def x = [a: 1]\ndef id(def m) { m }\nreturn id(*:x)\n");
        this.assertFailsWithSameException("def x = [a: 1]\ndef id(String a, int i) { [a, i] }\nreturn id(*:x)\n");
        this.assertFailsWithSameException("def x = [a: 1]\nreturn *:x\n");
    }

    @Test
    public void initialExpressionsInMethodsAreCpsTransformed() throws Throwable {
        this.assertEvaluate(Boolean.FALSE, "def m1() { true }\ndef m2(p = m1()){ false }\nm2()\n");
    }

    @Test
    public void methodsWithInitialExpressionsAreExpandedToCorrectOverloads() throws Throwable {
        this.assertEvaluate(List.of("abc", "xbc", "xyc", "xyz"), "def m2(a = 'a', b = 'b', c = 'c') {\n    a + b + c\n}\ndef r1 = m2()\ndef r2 = m2('x')\ndef r3 = m2('x', 'y')\ndef r4 = m2('x', 'y', 'z')\n[r1, r2, r3, r4]");
        this.assertEvaluate(List.of("abc", "xbc", "xby"), "def m2(a = 'a', b, c = 'c') {\n    a + b + c\n}\ndef r1 = m2('b')\ndef r2 = m2('x', 'b')\ndef r3 = m2('x', 'b', 'y')\n[r1, r2, r3]");
    }

    @Test
    public void voidMethodsWithInitialExpressionsAreExpandedToCorrectOverloads() throws Throwable {
        this.assertEvaluate(List.of("abc", "xbc", "xyc", "xyz"), "import groovy.transform.Field\n@Field def r = []\nvoid m2(a = 'a', b = 'b', c = 'c') {\n    r.add(a + b + c)\n}\nm2()\nm2('x')\nm2('x', 'y')\nm2('x', 'y', 'z')\nr");
        this.assertEvaluate(List.of("abc", "xbc", "xby"), "import groovy.transform.Field\n@Field def r = []\nvoid m2(a = 'a', b, c = 'c') {\n    r.add(a + b + c)\n}\nm2('b')\nm2('x', 'b')\nm2('x', 'b', 'y')\nr");
    }

    @Test
    public void illegalBreakStatement() throws Throwable {
        this.getBinding().setProperty("sentinel", (Object)1);
        this.evalCps("sentinel = 2; break;", AbstractGroovyCpsTest.ShouldFail.class, e -> MatcherAssert.assertThat((Object)e.toString(), (Matcher)CoreMatchers.containsString((String)"the break statement is only allowed inside loops or switches")));
        Assert.assertEquals((String)"Script should fail during compilation", (Object)1, (Object)this.getBinding().getProperty("sentinel"));
    }

    @Ignore(value="groovy-cps does not cast method return values to the declared type")
    @Test
    public void methodReturnValuesShouldBeCastToDeclaredReturnType() throws Throwable {
        this.assertEvaluate(true, "Boolean castToBoolean(def o) { o }\ncastToBoolean(123)\n");
    }

    @Test
    public void castToTypeShouldBeUsedForImplicitCasts() throws Throwable {
        this.assertEvaluate(List.of("toString", "toString", "toString", "asType"), "class Test {\n  def auditLog = []\n  @NonCPS\n  def asType(Class c) {\n    auditLog.add('asType')\n    'Test.asType'\n  }\n  @NonCPS\n  String toString() {\n    auditLog.add('toString')\n    'Test.toString'\n  }\n}\nTest t = new Test()\nString variable = t\nString[] array = [t]\n(String)t\nt as String\nt.auditLog\n");
    }

    @Test
    public void castRelatedMethodsShouldBeNonCps() throws Throwable {
        this.assertEvaluate(List.of(Boolean.valueOf(false), "asType class java.lang.Boolean"), "class Test {\n  def auditLog = []\n  def asType(Class c) {\n    auditLog.add('asType ' + c)\n    false\n  }\n}\ndef t = new Test()\n[t as Boolean, t.auditLog[0]]");
        this.assertEvaluate(List.of("asType class java.lang.Boolean"), "class Test {\n  def auditLog = []\n  @NonCPS\n  def asType(Class c) {\n    auditLog.add('asType ' + c)\n    null\n  }\n}\ndef t = new Test()\nt as Boolean\nt.auditLog");
        this.evalCps("class Test {\n  def auditLog = []\n  def asBoolean() {\n    auditLog.add('asBoolean')\n  }\n}\ndef t = new Test()\n(Boolean)t\nt.auditLog", AbstractGroovyCpsTest.ShouldFail.class, t -> this.ec.checkThat((Object)t.toString(), CoreMatchers.equalTo((Object)"java.lang.IllegalStateException: Test.asBoolean must be @NonCPS; see: https://jenkins.io/redirect/pipeline-cps-method-mismatches/")));
        this.assertEvaluate(List.of("asBoolean"), "class Test {\n  def auditLog = []\n  @NonCPS\n  def asBoolean() {\n    auditLog.add('asBoolean')\n  }\n}\ndef t = new Test()\n(Boolean)t\nt.auditLog");
    }

    @Test
    public void enums() throws Throwable {
        this.assertEvaluate("FIRST", "enum EnumTest { FIRST, SECOND }; EnumTest.FIRST.toString()");
        this.assertEvaluate("FIRST", "enum EnumTest { FIRST(), SECOND(); EnumTest() { } }; EnumTest.FIRST.toString()");
    }

    @Test
    public void anonymousClass() throws Throwable {
        this.assertEvaluate(6, "def o = new Object() { def plusOne(x) { x + 1 } }\no.plusOne(5)");
    }

    @Test
    public void assignmentExprsEvalToRHS() throws Throwable {
        this.assertEvaluate(List.of(Integer.valueOf(1), Integer.valueOf(1), Integer.valueOf(1)), "def a = b = c = 1\n[a, b, c]\n");
        this.assertEvaluate(List.of(Integer.valueOf(2), Integer.valueOf(3), Integer.valueOf(4)), "def a = b = c = 1\nc += b += a += 1\n[a, b, c]\n");
    }

    public static class Base {
        public String toString() {
            return "base";
        }
    }
}

