/*
 * Decompiled with CFR 0.152.
 */
package com.cloudbees.groovy.cps.tool;

import com.cloudbees.groovy.cps.tool.Translator;
import com.sun.codemodel.CodeWriter;
import com.sun.codemodel.writer.FileCodeWriter;
import groovy.lang.GroovyShell;
import hudson.remoting.Which;
import java.io.File;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import javax.tools.DiagnosticListener;
import javax.tools.JavaCompiler;
import javax.tools.JavaFileObject;
import javax.tools.StandardJavaFileManager;
import javax.tools.StandardLocation;
import javax.tools.ToolProvider;

public class Driver {
    public static void main(String[] args) throws Exception {
        new Driver().run(new File(args[0]));
    }

    public void run(File dir) throws Exception {
        JavaCompiler javac = ToolProvider.getSystemJavaCompiler();
        DiagnosticListener<JavaFileObject> errorListener = this.createErrorListener();
        try (StandardJavaFileManager fileManager = javac.getStandardFileManager(errorListener, Locale.getDefault(), Charset.defaultCharset());){
            fileManager.setLocation(StandardLocation.CLASS_PATH, Set.of(Which.jarFile(GroovyShell.class)));
            File groovySrcJar = Which.jarFile((URL)Driver.class.getClassLoader().getResource("groovy/lang/GroovyShell.java"));
            List<String> fileNames = List.of("DefaultGroovyMethods", "DefaultGroovyStaticMethods", "StringGroovyMethods");
            ArrayList<JavaFileObject> src = new ArrayList<JavaFileObject>();
            block5: for (JavaFileObject jfo : fileManager.list(StandardLocation.CLASS_PATH, "org.codehaus.groovy.runtime", Set.of(JavaFileObject.Kind.SOURCE), true)) {
                for (String name : fileNames) {
                    if (!jfo.toUri().toString().endsWith("/org/codehaus/groovy/runtime/" + name + ".java")) continue;
                    src.add(jfo);
                    continue block5;
                }
            }
            List<String> options = List.of("-proc:none");
            Translator t = new Translator(javac.getTask(null, fileManager, errorListener, options, null, src));
            for (String name : fileNames) {
                t.translate("org.codehaus.groovy.runtime." + name, "com.cloudbees.groovy.cps.Cps" + name, groovySrcJar.getName());
            }
            Files.createDirectories(dir.toPath(), new FileAttribute[0]);
            t.generateTo((CodeWriter)new FileCodeWriter(dir));
        }
    }

    private DiagnosticListener<JavaFileObject> createErrorListener() {
        return System.out::println;
    }
}

