/*
 * Decompiled with CFR 0.152.
 */
package com.cloudbees.sdk.extensibility.lifecycle;

import com.cloudbees.sdk.extensibility.lifecycle.Startable;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.logging.Level;
import java.util.logging.Logger;

public abstract class PeriodicService
implements Startable {
    private final AtomicBoolean inProgress = new AtomicBoolean();
    private static final Logger LOGGER = Logger.getLogger(PeriodicService.class.getName());

    @Override
    public void start() throws Exception {
        new Timer().schedule(new TimerTask(){

            @Override
            public void run() {
                try {
                    PeriodicService.this.doRun();
                }
                catch (Throwable e) {
                    LOGGER.log(Level.SEVERE, "Periodic task failed", e);
                }
            }
        }, this.getInitialDelay(), this.getPeriod());
    }

    protected abstract void run() throws Exception;

    public void doRun() throws Exception {
        if (this.inProgress.compareAndSet(false, true)) {
            try {
                this.run();
            }
            finally {
                this.inProgress.set(false);
            }
        } else {
            throw new IllegalStateException("Another run is already in progress");
        }
    }

    protected abstract long getPeriod();

    protected long getInitialDelay() {
        return this.getPeriod();
    }
}

