/*
 * Decompiled with CFR 0.152.
 */
package com.cloudbees.sdk.extensibility;

import java.lang.annotation.Annotation;
import java.lang.reflect.Proxy;
import java.util.Collections;
import java.util.Map;
import org.apache.commons.lang3.AnnotationUtils;

public class AnnotationLiteral {
    public static <T extends Annotation> T of(Class<T> type) {
        return AnnotationLiteral.of(type, Collections.emptyMap());
    }

    public static <T extends Annotation> T of(Class<T> type, Object value) {
        return AnnotationLiteral.of(type, "value", value);
    }

    public static <T extends Annotation> T of(Class<T> type, String key, Object value) {
        return AnnotationLiteral.of(type, Collections.singletonMap(key, value));
    }

    public static <T extends Annotation> T of(Class<T> type, Map<String, Object> values) {
        return (T)((Annotation)type.cast(Proxy.newProxyInstance(type.getClassLoader(), new Class[]{type}, (proxy, method, args) -> {
            String methodName;
            Annotation annotation = (Annotation)proxy;
            switch (methodName = method.getName()) {
                case "equals": {
                    return AnnotationUtils.equals((Annotation)annotation, (Annotation)((Annotation)args[0]));
                }
                case "toString": {
                    return AnnotationUtils.toString((Annotation)annotation);
                }
                case "hashCode": {
                    return AnnotationUtils.hashCode((Annotation)annotation);
                }
                case "annotationType": {
                    return type;
                }
            }
            if (!values.containsKey(methodName)) {
                throw new NoSuchMethodException("Missing value for annotation key: " + methodName);
            }
            return values.get(methodName);
        })));
    }
}

