/*
 * Decompiled with CFR 0.152.
 */
package com.checkmarx.jenkins.tools;

import com.checkmarx.jenkins.exception.ToolDetectionException;
import java.util.Locale;
import java.util.Map;
import lombok.NonNull;

public enum Platform {
    LINUX("linux_x64.tar.gz", "cx"),
    MAC_OS("darwin_x64.tar.gz", "cx"),
    WINDOWS("windows_x64.zip", "cx.exe");

    public final String packageExtension;
    public final String checkmarxWrapperFileName;

    private Platform(String packageExtension, String checkmarxWrapperFileName) {
        this.packageExtension = packageExtension;
        this.checkmarxWrapperFileName = checkmarxWrapperFileName;
    }

    @NonNull
    public static Platform current() throws ToolDetectionException {
        return Platform.detect(System.getProperties());
    }

    @NonNull
    private static Platform detect(@NonNull Map<Object, Object> systemProperties) throws ToolDetectionException {
        if (systemProperties == null) {
            throw new NullPointerException("systemProperties is marked non-null but is null");
        }
        String arch = ((String)systemProperties.get("os.name")).toLowerCase(Locale.ENGLISH);
        if (arch.contains("linux")) {
            return LINUX;
        }
        if (arch.contains("mac os x") || arch.contains("darwin") || arch.contains("osx")) {
            return MAC_OS;
        }
        if (arch.contains("windows")) {
            return WINDOWS;
        }
        throw new ToolDetectionException(arch + " is not supported CPU type");
    }
}

