/*
 * Decompiled with CFR 0.152.
 */
package com.checkmarx.jenkins.tools;

import com.checkmarx.jenkins.CheckmarxScanBuilder;
import com.checkmarx.jenkins.tools.CheckmarxInstaller;
import com.checkmarx.jenkins.tools.Platform;
import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.EnvVars;
import hudson.Extension;
import hudson.Launcher;
import hudson.model.EnvironmentSpecific;
import hudson.model.Node;
import hudson.model.TaskListener;
import hudson.remoting.Callable;
import hudson.remoting.VirtualChannel;
import hudson.slaves.NodeSpecific;
import hudson.tools.ToolDescriptor;
import hudson.tools.ToolInstallation;
import hudson.tools.ToolInstaller;
import hudson.tools.ToolProperty;
import java.io.IOException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Collections;
import java.util.List;
import jenkins.model.Jenkins;
import jenkins.security.MasterToSlaveCallable;
import org.jenkinsci.Symbol;
import org.kohsuke.stapler.DataBoundConstructor;

public class CheckmarxInstallation
extends ToolInstallation
implements EnvironmentSpecific<CheckmarxInstallation>,
NodeSpecific<CheckmarxInstallation> {
    @DataBoundConstructor
    public CheckmarxInstallation(@NonNull String name, @NonNull String home, List<? extends ToolProperty<?>> properties) {
        super(name, home, properties);
    }

    public CheckmarxInstallation forEnvironment(EnvVars envVars) {
        return new CheckmarxInstallation(this.getName(), envVars.expand(this.getHome()), this.getProperties().toList());
    }

    public CheckmarxInstallation forNode(@NonNull Node node, TaskListener taskListener) throws IOException, InterruptedException {
        return new CheckmarxInstallation(this.getName(), this.translateFor(node, taskListener), this.getProperties().toList());
    }

    public String getCheckmarxExecutable(@NonNull Launcher launcher) throws IOException, InterruptedException {
        if (this.getProperties().size() == 0) {
            return this.getHome();
        }
        VirtualChannel channel = launcher.getChannel();
        return channel == null ? null : (String)channel.call((Callable)new MasterToSlaveCallable<String, IOException>(){

            public String call() throws IOException {
                return CheckmarxInstallation.this.resolveExecutable(Platform.current());
            }
        });
    }

    private String resolveExecutable(Platform platform) throws IOException {
        String root = this.getHome();
        if (root == null) {
            return null;
        }
        String wrapperFileName = platform.checkmarxWrapperFileName;
        Path executable = Paths.get(root, new String[0]).resolve(wrapperFileName);
        if (!executable.toFile().exists()) {
            throw new IOException(String.format("Could not find executable <%s>", wrapperFileName));
        }
        return executable.toAbsolutePath().toString();
    }

    @Extension
    @Symbol(value={"checkmarx"})
    public static class CheckmarxInstallationDescriptor
    extends ToolDescriptor<CheckmarxInstallation> {
        @NonNull
        public String getDisplayName() {
            return "Checkmarx";
        }

        public List<? extends ToolInstaller> getDefaultInstallers() {
            return Collections.singletonList(new CheckmarxInstaller(null, "", null));
        }

        public CheckmarxInstallation[] getInstallations() {
            Jenkins instance = Jenkins.get();
            return ((CheckmarxScanBuilder.CheckmarxScanBuilderDescriptor)instance.getDescriptorByType(CheckmarxScanBuilder.CheckmarxScanBuilderDescriptor.class)).getInstallations();
        }

        public void setInstallations(CheckmarxInstallation ... installations) {
            Jenkins instance = Jenkins.get();
            ((CheckmarxScanBuilder.CheckmarxScanBuilderDescriptor)instance.getDescriptorByType(CheckmarxScanBuilder.CheckmarxScanBuilderDescriptor.class)).setInstallations(installations);
        }
    }
}

