/*
 * Decompiled with CFR 0.152.
 */
package com.checkmarx.jenkins;

import com.checkmarx.ast.results.ReportFormat;
import com.checkmarx.ast.wrapper.CxConfig;
import com.checkmarx.ast.wrapper.CxException;
import com.checkmarx.ast.wrapper.CxWrapper;
import com.checkmarx.jenkins.CheckmarxScanBuilder;
import com.checkmarx.jenkins.logger.CxLoggerAdapter;
import com.checkmarx.jenkins.model.ScanConfig;
import com.checkmarx.jenkins.tools.CheckmarxInstallation;
import hudson.EnvVars;
import hudson.slaves.EnvironmentVariablesNodeProperty;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.UUID;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Stream;
import jenkins.model.Jenkins;
import org.slf4j.Logger;

public class PluginUtils {
    public static final String CHECKMARX_AST_RESULTS = "checkmarx-ast-results";
    public static final String CHECKMARX_AST_RESULTS_HTML = "checkmarx-ast-results.html";
    public static final String CHECKMARX_AST_RESULTS_JSON = "checkmarx-ast-results.json";
    public static final String REGEX_SCAN_ID_FROM_LOGS = "\"ID\":\"([0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{12})\"";
    private static final String JENKINS = "Jenkins";
    static final String CX_CLIENT_ID_ENV_KEY = "CX_CLIENT_ID";
    static final String CX_CLIENT_SECRET_ENV_KEY = "CX_CLIENT_SECRET";
    public static final String HTTP_PROXY = "HTTP_PROXY";
    public static final String defaultOutputName = "cx_result";

    public static CheckmarxInstallation findCheckmarxInstallation(String checkmarxInstallation) {
        CheckmarxScanBuilder.CheckmarxScanBuilderDescriptor descriptor = (CheckmarxScanBuilder.CheckmarxScanBuilderDescriptor)Jenkins.get().getDescriptorByType(CheckmarxScanBuilder.CheckmarxScanBuilderDescriptor.class);
        return Stream.of(descriptor.getInstallations()).filter(installation -> installation.getName().equals(checkmarxInstallation)).findFirst().orElse(null);
    }

    public static List<String> submitScanDetailsToWrapper(ScanConfig scanConfig, String checkmarxCliExecutable, CxLoggerAdapter log) throws IOException {
        log.info("Submitting the scan details to the CLI wrapper.");
        CxConfig cxConfig = PluginUtils.initiateWrapperObject(scanConfig, checkmarxCliExecutable);
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("--agent", JENKINS);
        params.put("-s", scanConfig.getSourceDirectory());
        params.put("--project-name", scanConfig.getProjectName());
        params.put("--branch", scanConfig.getBranchName());
        CxWrapper cxWrapper = new CxWrapper(cxConfig, (Logger)log);
        return cxWrapper.buildScanCreateArguments(params, scanConfig.getAdditionalOptions());
    }

    public static List<String> scanCancel(UUID scanId, ScanConfig scanConfig, String checkmarxCliExecutable, CxLoggerAdapter log) throws IOException, InterruptedException {
        CxConfig cxConfig = PluginUtils.initiateWrapperObject(scanConfig, checkmarxCliExecutable);
        CxWrapper cxWrapper = new CxWrapper(cxConfig, (Logger)log);
        return cxWrapper.buildScanCancelArguments(scanId);
    }

    public static List<String> generateHTMLReport(UUID scanId, ScanConfig scanConfig, String checkmarxCliExecutable, CxLoggerAdapter log) throws IOException {
        CxConfig cxConfig = PluginUtils.initiateWrapperObject(scanConfig, checkmarxCliExecutable);
        CxWrapper cxWrapper = new CxWrapper(cxConfig, (Logger)log);
        return cxWrapper.buildResultsArguments(scanId, ReportFormat.summaryHTML);
    }

    public static List<String> generateJsonReport(UUID scanId, ScanConfig scanConfig, String checkmarxCliExecutable, CxLoggerAdapter log) throws IOException {
        CxConfig cxConfig = PluginUtils.initiateWrapperObject(scanConfig, checkmarxCliExecutable);
        CxWrapper cxWrapper = new CxWrapper(cxConfig, (Logger)log);
        return cxWrapper.buildResultsArguments(scanId, ReportFormat.summaryJSON);
    }

    public static String authValidate(ScanConfig scanConfig, String checkmarxCliExecutable) throws IOException, InterruptedException, CxException {
        CxConfig cxConfig = PluginUtils.initiateWrapperObject(scanConfig, checkmarxCliExecutable);
        cxConfig.setClientId(scanConfig.getCheckmarxToken().getClientId());
        cxConfig.setClientSecret(scanConfig.getCheckmarxToken().getToken().getPlainText());
        CxWrapper cxWrapper = new CxWrapper(cxConfig);
        return cxWrapper.authValidate();
    }

    private static CxConfig initiateWrapperObject(ScanConfig scanConfig, String checkmarxCliExecutable) {
        return CxConfig.builder().baseUri(scanConfig.getServerUrl()).baseAuthUri(scanConfig.getBaseAuthUrl()).tenant(scanConfig.getTenantName()).additionalParameters(null).pathToExecutable(checkmarxCliExecutable).build();
    }

    public static String getScanIdFromLogFile(String logs) {
        String regex = REGEX_SCAN_ID_FROM_LOGS;
        Pattern pattern = Pattern.compile(REGEX_SCAN_ID_FROM_LOGS);
        Matcher matcher = pattern.matcher(logs);
        if (matcher.find()) {
            return matcher.group(1);
        }
        return "";
    }

    public static boolean isPolicyViolated(String logs) {
        String policyViolationRegex = "Policy Management Violation[:\\s-].*";
        Pattern policyPattern = Pattern.compile("Policy Management Violation[:\\s-].*");
        Matcher policyMatcher = policyPattern.matcher(logs);
        if (policyMatcher.find()) {
            String breakBuildRegex = "Break Build:\\s*true";
            Pattern breakBuildPattern = Pattern.compile("Break Build:\\s*true", 2);
            Matcher breakBuildMatcher = breakBuildPattern.matcher(logs);
            return breakBuildMatcher.find();
        }
        return false;
    }

    public static void insertSecretsAsEnvVars(ScanConfig scanConfig, EnvVars envVars) throws IOException, InterruptedException {
        envVars.put(CX_CLIENT_ID_ENV_KEY, scanConfig.getCheckmarxToken().getClientId());
        envVars.put(CX_CLIENT_SECRET_ENV_KEY, scanConfig.getCheckmarxToken().getToken().getPlainText());
    }

    public static String getProxy() {
        EnvVars envVars = PluginUtils.getEnvVars();
        String httpProxyStr = (String)envVars.get((Object)HTTP_PROXY);
        return httpProxyStr;
    }

    private static EnvVars getEnvVars() {
        EnvironmentVariablesNodeProperty environmentVariablesNodeProperty = (EnvironmentVariablesNodeProperty)Jenkins.get().getGlobalNodeProperties().get(EnvironmentVariablesNodeProperty.class);
        return environmentVariablesNodeProperty != null ? environmentVariablesNodeProperty.getEnvVars() : new EnvVars();
    }
}

