/*
 * Decompiled with CFR 0.152.
 */
package com.checkmarx.jenkins;

import com.checkmarx.ast.wrapper.CxException;
import com.checkmarx.jenkins.CheckmarxScanResultsAction;
import com.checkmarx.jenkins.PluginUtils;
import com.checkmarx.jenkins.credentials.CheckmarxApiToken;
import com.checkmarx.jenkins.exception.CheckmarxException;
import com.checkmarx.jenkins.logger.CxLoggerAdapter;
import com.checkmarx.jenkins.model.ScanConfig;
import com.checkmarx.jenkins.tools.CheckmarxInstallation;
import com.cloudbees.plugins.credentials.CredentialsMatcher;
import com.cloudbees.plugins.credentials.CredentialsMatchers;
import com.cloudbees.plugins.credentials.CredentialsProvider;
import com.cloudbees.plugins.credentials.common.StandardListBoxModel;
import edu.umd.cs.findbugs.annotations.Nullable;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import hudson.AbortException;
import hudson.EnvVars;
import hudson.Extension;
import hudson.FilePath;
import hudson.Launcher;
import hudson.Util;
import hudson.model.AbstractProject;
import hudson.model.Action;
import hudson.model.Computer;
import hudson.model.Item;
import hudson.model.ItemGroup;
import hudson.model.Job;
import hudson.model.Node;
import hudson.model.Result;
import hudson.model.Run;
import hudson.model.TaskListener;
import hudson.security.ACL;
import hudson.slaves.EnvironmentVariablesNodeProperty;
import hudson.tasks.ArtifactArchiver;
import hudson.tasks.BuildStepDescriptor;
import hudson.tasks.Builder;
import hudson.tools.ToolInstallation;
import hudson.util.ArgumentListBuilder;
import hudson.util.DescribableList;
import hudson.util.FormValidation;
import hudson.util.ListBoxModel;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Serializable;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.stream.Collectors;
import jenkins.model.Jenkins;
import jenkins.tasks.SimpleBuildStep;
import lombok.NonNull;
import net.sf.json.JSONObject;
import org.acegisecurity.Authentication;
import org.apache.commons.lang.StringUtils;
import org.jenkinsci.Symbol;
import org.kohsuke.stapler.AncestorInPath;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.DataBoundSetter;
import org.kohsuke.stapler.QueryParameter;
import org.kohsuke.stapler.StaplerRequest;
import org.kohsuke.stapler.verb.POST;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CheckmarxScanBuilder
extends Builder
implements SimpleBuildStep {
    public static final String DEFAULT_BRANCH_WARN = "If blank, branch name points to %s, %s or %s environment variables";
    public static final String GIT_BRANCH = "GIT_BRANCH";
    public static final String GIT_BRANCH_VAR = "${GIT_BRANCH}";
    public static final String CVS_BRANCH = "CVS_BRANCH";
    public static final String CVS_BRANCH_VAR = "${CVS_BRANCH}";
    public static final String SVN_REVISION = "SVN_REVISION";
    public static final String SVN_REVISION_VAR = "${SVN_REVISION}";
    public static final String LOGFILE = "./output.log";
    private static final List<String> SENSITIVE_KEYS = Arrays.asList("--apikey", "--scs-repo-token", "--client-secret", "--token");
    CxLoggerAdapter log;
    @Nullable
    private String serverUrl;
    private boolean useAuthenticationUrl;
    private String baseAuthUrl;
    private String tenantName;
    private String projectName;
    private String branchName;
    private String credentialsId;
    private String checkmarxInstallation;
    private String additionalOptions;
    private boolean useOwnAdditionalOptions;
    private boolean useOwnServerCredentials;

    @DataBoundConstructor
    public CheckmarxScanBuilder(boolean useOwnServerCredentials, @Nullable String serverUrl, boolean useAuthenticationUrl, String baseAuthUrl, String tenantName, String projectName, String credentialsId, boolean useOwnAdditionalOptions, String additionalOptions, String branchName) {
        this.useOwnServerCredentials = useOwnServerCredentials;
        this.serverUrl = serverUrl;
        this.useAuthenticationUrl = useAuthenticationUrl;
        this.baseAuthUrl = baseAuthUrl;
        this.tenantName = tenantName;
        this.projectName = projectName;
        this.credentialsId = credentialsId;
        this.useOwnAdditionalOptions = useOwnAdditionalOptions;
        this.additionalOptions = additionalOptions;
        this.branchName = branchName;
    }

    public CheckmarxScanBuilder() {
    }

    public boolean getUseOwnServerCredentials() {
        return this.useOwnServerCredentials;
    }

    @DataBoundSetter
    public void setUseOwnServerCredentials(boolean useOwnServerCredentials) {
        this.useOwnServerCredentials = useOwnServerCredentials;
    }

    @Nullable
    public String getServerUrl() {
        return this.serverUrl;
    }

    @DataBoundSetter
    public void setServerUrl(@Nullable String serverUrl) {
        this.serverUrl = serverUrl;
    }

    public String getTenantName() {
        return this.tenantName;
    }

    @DataBoundSetter
    public void setTenantName(@Nullable String tenantName) {
        this.tenantName = tenantName;
    }

    public String getProjectName() {
        return this.projectName;
    }

    @DataBoundSetter
    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }

    public String getBranchName() {
        return this.branchName;
    }

    @DataBoundSetter
    public void setBranchName(String branchName) {
        this.branchName = branchName;
    }

    public String getCredentialsId() {
        return this.credentialsId;
    }

    @DataBoundSetter
    public void setCredentialsId(String credentialsId) {
        this.credentialsId = credentialsId;
    }

    public boolean getUseOwnAdditionalOptions() {
        return this.useOwnAdditionalOptions;
    }

    @DataBoundSetter
    public void setUseOwnAdditionalOptions(boolean useOwnAdditionalOptions) {
        this.useOwnAdditionalOptions = useOwnAdditionalOptions;
    }

    public String getAdditionalOptions() {
        return this.additionalOptions;
    }

    @DataBoundSetter
    public void setAdditionalOptions(@Nullable String additionalOptions) {
        this.additionalOptions = additionalOptions;
    }

    public String getCheckmarxInstallation() {
        return this.checkmarxInstallation;
    }

    @DataBoundSetter
    public void setCheckmarxInstallation(String checkmarxInstallation) {
        this.checkmarxInstallation = checkmarxInstallation;
    }

    public boolean isUseAuthenticationUrl() {
        return this.useAuthenticationUrl;
    }

    @DataBoundSetter
    public void setUseAuthenticationUrl(boolean useAuthenticationUrl) {
        this.useAuthenticationUrl = useAuthenticationUrl;
    }

    public String getBaseAuthUrl() {
        return this.baseAuthUrl;
    }

    @DataBoundSetter
    public void setBaseAuthUrl(String baseAuthUrl) {
        this.baseAuthUrl = baseAuthUrl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void perform(@NonNull Run<?, ?> run, @NonNull FilePath workspace, EnvVars envVars, @NonNull Launcher launcher, final @NonNull TaskListener listener) {
        String logFile;
        Node node;
        CheckmarxInstallation installation;
        ScanConfig scanConfig;
        if (run == null) {
            throw new NullPointerException("run is marked non-null but is null");
        }
        if (workspace == null) {
            throw new NullPointerException("workspace is marked non-null but is null");
        }
        if (launcher == null) {
            throw new NullPointerException("launcher is marked non-null but is null");
        }
        if (listener == null) {
            throw new NullPointerException("listener is marked non-null but is null");
        }
        CheckmarxScanBuilderDescriptor descriptor = this.getDescriptor();
        this.log = new CxLoggerAdapter(listener.getLogger());
        try {
            scanConfig = this.resolveConfiguration(run, workspace, descriptor, envVars);
        }
        catch (Exception e) {
            this.log.info(e.getMessage());
            run.setResult(Result.FAILURE);
            return;
        }
        PluginUtils.insertSecretsAsEnvVars(scanConfig, envVars);
        this.printConfiguration(envVars, descriptor, this.log);
        if (!this.getUseOwnServerCredentials()) {
            this.checkmarxInstallation = descriptor.getCheckmarxInstallation();
        }
        if ((installation = PluginUtils.findCheckmarxInstallation(this.checkmarxInstallation)) == null) {
            this.log.info("Checkmarx installation named '" + this.checkmarxInstallation + "' was not found. Please configure the build properly and retry.");
            run.setResult(Result.FAILURE);
            return;
        }
        Computer computer = workspace.toComputer();
        Node node2 = node = computer != null ? computer.getNode() : null;
        if (node == null) {
            this.log.info("Not running on a build node.");
            run.setResult(Result.FAILURE);
            return;
        }
        installation = installation.forNode(node, listener);
        String checkmarxCliExecutable = Optional.of((installation = installation.forEnvironment(envVars)).getCheckmarxExecutable(launcher)).orElseThrow(() -> new Exception("Cannot use node"));
        if (checkmarxCliExecutable == null) {
            this.log.info("Can't retrieve the Checkmarx executable.");
            run.setResult(Result.FAILURE);
            return;
        }
        CheckmarxApiToken checkmarxToken = scanConfig.getCheckmarxToken();
        if (checkmarxToken == null) {
            this.log.error("Checkmarx credentials with ID '" + this.credentialsId + "' was not found. Please configure the build properly and retry.");
            run.setResult(Result.FAILURE);
            return;
        }
        List<String> argumentsForCommand = PluginUtils.submitScanDetailsToWrapper(scanConfig, checkmarxCliExecutable, this.log);
        ArgumentListBuilder arguments = new ArgumentListBuilder();
        FilePath tempDir = workspace.createTempDir("cx", "");
        final ByteArrayOutputStream fos = new ByteArrayOutputStream();
        arguments.add(argumentsForCommand);
        int exitCode = 0;
        try {
            exitCode = launcher.launch().cmds(arguments).envs((Map)envVars).stdout(new OutputStream(){

                @Override
                public void write(int b) throws IOException {
                    fos.write(b);
                    listener.getLogger().write(b);
                }

                @Override
                public void flush() throws IOException {
                    super.flush();
                    fos.flush();
                    listener.getLogger().flush();
                }

                @Override
                public void close() throws IOException {
                    super.close();
                    fos.close();
                    listener.getLogger().close();
                }
            }).join();
            this.log.error(String.format("Exit code from AST-CLI: %s", exitCode));
            logFile = fos.toString(String.valueOf(StandardCharsets.UTF_8));
            this.log.info("Start to check for policy violations in the log file");
            if (PluginUtils.isPolicyViolated(logFile)) {
                this.log.info("Setting build result to FAILURE due to policy violation");
                run.setResult(Result.FAILURE);
                throw new AbortException("Pipeline failed due to Policy Management Violation detected in scan results and break build set to true.");
            }
        }
        catch (InterruptedException interruptedException) {
            String logFile2 = fos.toString(String.valueOf(StandardCharsets.UTF_8));
            String scanId = PluginUtils.getScanIdFromLogFile(logFile2);
            if (!scanId.isEmpty()) {
                this.log.info("Cancelling scan with id: {}", (Object)scanId);
                launcher.launch().cmds(PluginUtils.scanCancel(UUID.fromString(scanId), scanConfig, checkmarxCliExecutable, this.log)).envs((Map)envVars).stdout((OutputStream)listener.getLogger()).join();
                this.log.info("Successfully canceled scan with id: {}", (Object)scanId);
            }
            run.setResult(Result.ABORTED);
        }
        catch (Exception e) {
            this.log.info(e.getMessage());
            run.setResult(Result.FAILURE);
        }
        logFile = fos.toString(String.valueOf(StandardCharsets.UTF_8));
        String scanId = PluginUtils.getScanIdFromLogFile(logFile);
        if (scanId.isEmpty()) {
            this.log.error("Scan Scan ID is empty");
            run.setResult(Result.FAILURE);
            throw new AbortException("Scan Failed");
        }
        ArgumentListBuilder htmlArguments = new ArgumentListBuilder();
        ArgumentListBuilder jsonArguments = new ArgumentListBuilder();
        try {
            List<String> htmlReportCommand = PluginUtils.generateHTMLReport(UUID.fromString(scanId), scanConfig, checkmarxCliExecutable, this.log);
            htmlArguments.add(htmlReportCommand);
            htmlArguments.add("--output-path");
            htmlArguments.add(tempDir.getRemote());
            htmlArguments.add("--output-name");
            htmlArguments.add("checkmarx-ast-results");
            launcher.launch().cmds(htmlArguments).envs((Map)envVars).stdout((OutputStream)listener.getLogger()).join();
            List<String> jsonReportCommand = PluginUtils.generateJsonReport(UUID.fromString(scanId), scanConfig, checkmarxCliExecutable, this.log);
            jsonArguments.add(jsonReportCommand);
            jsonArguments.add("--output-path");
            jsonArguments.add(tempDir.getRemote());
            jsonArguments.add("--output-name");
            jsonArguments.add("checkmarx-ast-results");
            launcher.launch().cmds(jsonArguments).envs((Map)envVars).stdout((OutputStream)listener.getLogger()).join();
            FilePath htmlReportFilePath = tempDir.child("checkmarx-ast-results.html");
            FilePath jsonReportFilePath = tempDir.child("checkmarx-ast-results.json");
            ArtifactArchiver artifactArchiverHtml = new ArtifactArchiver(workspace.toURI().relativize(htmlReportFilePath.toURI()).toString());
            artifactArchiverHtml.perform(run, workspace, envVars, launcher, listener);
            ArtifactArchiver artifactArchiverJson = new ArtifactArchiver(workspace.toURI().relativize(jsonReportFilePath.toURI()).toString());
            artifactArchiverJson.perform(run, workspace, envVars, launcher, listener);
            this.saveInArtifactAdditionalReports(scanConfig, workspace, envVars, launcher, listener, run, tempDir);
        }
        finally {
            tempDir.deleteContents();
            tempDir.delete();
        }
        if (run.getActions(CheckmarxScanResultsAction.class).isEmpty()) {
            run.addAction((Action)new CheckmarxScanResultsAction());
        }
        if (exitCode != 0) {
            run.setResult(Result.FAILURE);
            this.log.info("Failed report generated");
            throw new AbortException("Scan Failed");
        }
        run.setResult(Result.SUCCESS);
    }

    private void saveInArtifactAdditionalReports(ScanConfig scanConfig, FilePath workspace, EnvVars envVars, Launcher launcher, TaskListener listener, Run<?, ?> run, FilePath tempDir) {
        String[] formats;
        if (scanConfig.getAdditionalOptions() == null || !scanConfig.getAdditionalOptions().contains("--report-format")) {
            return;
        }
        String additionalOptions = scanConfig.getAdditionalOptions();
        String formatTypes = this.extractOptionValue(additionalOptions, "--report-format");
        for (String formatType : formats = formatTypes.split(",")) {
            try {
                String fileName = (additionalOptions.contains("--output-name") ? this.extractOptionValue(additionalOptions, "--output-name") : "cx_result") + "." + formatType;
                String outputPath = this.extractOptionValue(additionalOptions, "--output-path");
                this.log.info("Output path: " + outputPath);
                if (outputPath == null || outputPath.isEmpty()) {
                    outputPath = workspace.getRemote();
                } else {
                    workspace = new FilePath(new File(outputPath));
                }
                File fileToCopy = new File(outputPath, fileName);
                if (!fileToCopy.exists()) continue;
                this.createArchiveFile(tempDir, fileName, fileToCopy, run, workspace, envVars, launcher, listener);
            }
            catch (Exception e) {
                this.log.error(String.format("Error saving additional reports (%s format): %s", formatType, e.getMessage()));
            }
        }
    }

    private void createArchiveFile(FilePath tempDir, String fileName, File fileToCopy, Run<?, ?> run, FilePath workspace, EnvVars envVars, Launcher launcher, TaskListener listener) throws IOException, InterruptedException {
        this.log.info("Copying file to workspace: " + tempDir.getRemote());
        FilePath tempDirPath = tempDir.child(fileName);
        new FilePath(fileToCopy).copyTo(tempDirPath);
        ArtifactArchiver artifactArchiver = new ArtifactArchiver(tempDirPath.getName());
        artifactArchiver.perform(run, workspace, envVars, launcher, listener);
    }

    private String extractOptionValue(String options, String optionKey) {
        String[] parts;
        if (options.contains(optionKey) && (parts = options.split(optionKey, 2)).length > 1) {
            String remaining = parts[1].trim();
            if (remaining.startsWith("\"")) {
                int endIndex = remaining.indexOf("\"", 1);
                if (endIndex > 0) {
                    return remaining.substring(1, endIndex);
                }
            } else {
                return remaining.split(" ")[0];
            }
        }
        return "";
    }

    private String getBranchNameOrDefault(EnvVars envVars) {
        if (StringUtils.isNotEmpty((String)this.getBranchName())) {
            return envVars.expand(this.getBranchName());
        }
        if (StringUtils.isNotEmpty((String)((String)envVars.get((Object)GIT_BRANCH)))) {
            return ((String)envVars.get((Object)GIT_BRANCH)).replaceAll("^([^/]+)/", "");
        }
        if (StringUtils.isNotEmpty((String)((String)envVars.get((Object)CVS_BRANCH)))) {
            return (String)envVars.get((Object)CVS_BRANCH);
        }
        if (StringUtils.isNotEmpty((String)((String)envVars.get((Object)SVN_REVISION)))) {
            return (String)envVars.get((Object)SVN_REVISION);
        }
        return "";
    }

    private String getBranchToPrint(EnvVars envVars) {
        if (StringUtils.isNotEmpty((String)this.getBranchName())) {
            return this.getBranchName();
        }
        if (StringUtils.isNotEmpty((String)((String)envVars.get((Object)GIT_BRANCH)))) {
            return GIT_BRANCH_VAR;
        }
        if (StringUtils.isNotEmpty((String)((String)envVars.get((Object)CVS_BRANCH)))) {
            return CVS_BRANCH_VAR;
        }
        if (StringUtils.isNotEmpty((String)((String)envVars.get((Object)SVN_REVISION)))) {
            return SVN_REVISION_VAR;
        }
        return "";
    }

    private String maskSensitiveValues(String input, List<String> sensitiveKeys) {
        if (StringUtils.isNotEmpty((String)input)) {
            return sensitiveKeys.stream().reduce(input, (maskedInput, key) -> maskedInput.replaceAll(key + "\\s+\\S+", key + " ********"));
        }
        return input;
    }

    private void printConfiguration(EnvVars envVars, CheckmarxScanBuilderDescriptor descriptor, CxLoggerAdapter log) {
        String authUrl;
        boolean useGlobalAuthUrl;
        log.info("----**** Checkmarx Scan Configuration ****----");
        String serverUrl = this.getUseOwnServerCredentials() ? this.getServerUrl() : descriptor.getServerUrl();
        log.info("Checkmarx Server Url: " + serverUrl);
        boolean useOwnBaseAuthUrl = this.getUseOwnServerCredentials() && this.isUseAuthenticationUrl();
        boolean bl = useGlobalAuthUrl = !useOwnBaseAuthUrl && descriptor.getUseAuthenticationUrl();
        String string = useOwnBaseAuthUrl ? this.getBaseAuthUrl() : (authUrl = useGlobalAuthUrl ? descriptor.getBaseAuthUrl() : "");
        if (StringUtils.isNotEmpty((String)authUrl)) {
            log.info("Checkmarx Auth Server Url: " + authUrl);
        }
        String tenantName = this.getUseOwnServerCredentials() ? this.getTenantName() : descriptor.getTenantName();
        log.info("Tenant Name: " + Optional.ofNullable(tenantName).orElse(""));
        log.info("Project Name: " + this.getProjectName());
        log.info("Branch name: " + this.getBranchToPrint(envVars));
        log.info("Using global additional options: " + !this.getUseOwnAdditionalOptions());
        String additionalOptions = this.getUseOwnAdditionalOptions() ? this.getAdditionalOptions() : descriptor.getAdditionalOptions();
        additionalOptions = this.maskSensitiveValues(additionalOptions, SENSITIVE_KEYS);
        log.info("Additional Options: " + Optional.ofNullable(additionalOptions).orElse(""));
    }

    private ScanConfig resolveConfiguration(Run<?, ?> run, FilePath workspace, CheckmarxScanBuilderDescriptor descriptor, EnvVars envVars) throws CheckmarxException {
        Object additionalOptions;
        this.checkMandatoryFields(descriptor);
        ScanConfig scanConfig = new ScanConfig();
        scanConfig.setProjectName(envVars.expand(this.getProjectName()));
        if (descriptor.getUseAuthenticationUrl()) {
            scanConfig.setBaseAuthUrl(envVars.expand(descriptor.getBaseAuthUrl()));
        }
        if (this.getUseOwnServerCredentials()) {
            scanConfig.setServerUrl(envVars.expand(this.getServerUrl()));
            scanConfig.setTenantName(envVars.expand(Util.fixEmptyAndTrim((String)this.getTenantName())));
            if (this.isUseAuthenticationUrl()) {
                scanConfig.setBaseAuthUrl(envVars.expand(this.getBaseAuthUrl()));
            }
            scanConfig.setCheckmarxToken(this.getCheckmarxTokenCredential(run, this.getCredentialsId()));
        } else {
            scanConfig.setServerUrl(envVars.expand(descriptor.getServerUrl()));
            scanConfig.setTenantName(envVars.expand(Util.fixEmptyAndTrim((String)descriptor.getTenantName())));
            scanConfig.setCheckmarxToken(this.getCheckmarxTokenCredential(run, descriptor.getCredentialsId()));
        }
        String branchName = this.getBranchNameOrDefault(envVars);
        scanConfig.setBranchName(branchName);
        Object object = additionalOptions = this.getUseOwnAdditionalOptions() ? this.getAdditionalOptions() : descriptor.getAdditionalOptions();
        if (Util.fixEmptyAndTrim((String)additionalOptions) != null) {
            String prefixPath = workspace.getRemote().replace("\\", "\\\\");
            additionalOptions = ((String)additionalOptions).contains("--output-path") ? ((String)additionalOptions).replaceAll("(--output-path\\s+)(\"[^\"]*\"|\\S+)", "$1\"" + prefixPath + "\"") : (String)additionalOptions + String.format(" --output-path \"%s\"", prefixPath);
            scanConfig.setAdditionalOptions(envVars.expand((String)additionalOptions));
        }
        scanConfig.setSourceDirectory(workspace.getRemote());
        return scanConfig;
    }

    private void checkMandatoryFields(CheckmarxScanBuilderDescriptor descriptor) throws CheckmarxException {
        if (Util.fixEmptyAndTrim((String)this.getProjectName()) == null) {
            throw new CheckmarxException("Please provide a valid project name.");
        }
        if (!this.getUseOwnServerCredentials() && Util.fixEmptyAndTrim((String)descriptor.getServerUrl()) == null) {
            throw new CheckmarxException("Please setup the server url in the global settings.");
        }
        if (!this.getUseOwnServerCredentials() && Util.fixEmptyAndTrim((String)descriptor.getCredentialsId()) == null) {
            throw new CheckmarxException("Please setup the credential in the global settings");
        }
    }

    private CheckmarxApiToken getCheckmarxTokenCredential(Run<?, ?> run, String credentialsId) {
        return (CheckmarxApiToken)CredentialsProvider.findCredentialById((String)credentialsId, CheckmarxApiToken.class, run);
    }

    public CheckmarxScanBuilderDescriptor getDescriptor() {
        return (CheckmarxScanBuilderDescriptor)super.getDescriptor();
    }

    @Symbol(value={"checkmarxASTScanner"})
    @Extension
    public static class CheckmarxScanBuilderDescriptor
    extends BuildStepDescriptor<Builder> {
        private static final Logger LOG = LoggerFactory.getLogger((String)CheckmarxScanBuilderDescriptor.class.getName());
        @Nullable
        private String serverUrl;
        private String tenantName;
        private String baseAuthUrl;
        private boolean useAuthenticationUrl;
        private String checkmarxInstallation;
        private String credentialsId;
        @Nullable
        private String additionalOptions;
        private volatile CheckmarxInstallation[] installations = new CheckmarxInstallation[0];

        public CheckmarxScanBuilderDescriptor() {
            this.load();
        }

        @NonNull
        public String getDisplayName() {
            return "Execute Checkmarx AST Scan";
        }

        public boolean isApplicable(Class<? extends AbstractProject> aClass) {
            return true;
        }

        @SuppressFBWarnings(value={"EI_EXPOSE_REP"})
        public CheckmarxInstallation[] getInstallations() {
            return this.installations;
        }

        public void setInstallations(CheckmarxInstallation ... installations) {
            this.installations = installations;
            this.save();
        }

        @Nullable
        public String getServerUrl() {
            return this.serverUrl;
        }

        public void setServerUrl(@Nullable String serverUrl) {
            this.serverUrl = serverUrl;
        }

        public String getBaseAuthUrl() {
            return this.baseAuthUrl;
        }

        public void setBaseAuthUrl(@Nullable String baseAuthUrl) {
            this.baseAuthUrl = baseAuthUrl;
        }

        public boolean getUseAuthenticationUrl() {
            return this.useAuthenticationUrl;
        }

        public void setUseAuthenticationUrl(boolean useAuthenticationUrl) {
            this.useAuthenticationUrl = useAuthenticationUrl;
        }

        public String getTenantName() {
            return this.tenantName;
        }

        public void setTenantName(@Nullable String tenantName) {
            this.tenantName = tenantName;
        }

        public String getCredentialsId() {
            return this.credentialsId;
        }

        public void setCredentialsId(String credentialsId) {
            this.credentialsId = credentialsId;
        }

        @Nullable
        public String getAdditionalOptions() {
            return this.additionalOptions;
        }

        public void setAdditionalOptions(@Nullable String additionalOptions) {
            this.additionalOptions = additionalOptions;
        }

        public String getCheckmarxInstallation() {
            return this.checkmarxInstallation;
        }

        public void setCheckmarxInstallation(String checkmarxInstallation) {
            this.checkmarxInstallation = checkmarxInstallation;
        }

        public boolean hasInstallationsAvailable() {
            if (LOG.isTraceEnabled()) {
                LOG.trace("Available Checkmarx installations: {}", (Object)Arrays.stream(this.installations).map(ToolInstallation::getName).collect(Collectors.joining(",", "[", "]")));
            }
            return this.installations.length > 0;
        }

        public boolean configure(StaplerRequest req, JSONObject formData) {
            JSONObject pluginData = formData.getJSONObject("checkmarx");
            req.bindJSON((Object)this, pluginData);
            this.save();
            return false;
        }

        @POST
        public FormValidation doCheckServerUrl(@QueryParameter String value) {
            if (Util.fixEmptyAndTrim((String)value) == null) {
                return FormValidation.error((String)"Server Url cannot be empty");
            }
            return FormValidation.ok();
        }

        @POST
        public FormValidation doTestConnection(@QueryParameter String serverUrl, @QueryParameter boolean useAuthenticationUrl, @QueryParameter String baseAuthUrl, @QueryParameter String tenantName, @QueryParameter String credentialsId, @QueryParameter String checkmarxInstallation, @AncestorInPath Item item, @AncestorInPath Job job) {
            try {
                if (job == null) {
                    Jenkins.get().checkPermission(Jenkins.ADMINISTER);
                } else {
                    job.checkPermission(Item.CONFIGURE);
                }
                String cxInstallationPath = this.getCheckmarxInstallationPath(checkmarxInstallation);
                CheckmarxApiToken checkmarxApiToken = this.getCheckmarxApiToken(credentialsId);
                DescribableList globalNodeProperties = Jenkins.get().getGlobalNodeProperties();
                EnvironmentVariablesNodeProperty environmentVariablesNodeProperty = (EnvironmentVariablesNodeProperty)globalNodeProperties.get(EnvironmentVariablesNodeProperty.class);
                EnvVars envVars = environmentVariablesNodeProperty != null ? environmentVariablesNodeProperty.getEnvVars() : new EnvVars();
                ScanConfig scanConfig = new ScanConfig();
                scanConfig.setServerUrl(envVars.expand(serverUrl));
                scanConfig.setBaseAuthUrl(useAuthenticationUrl ? envVars.expand(baseAuthUrl) : null);
                scanConfig.setTenantName(envVars.expand(tenantName));
                scanConfig.setCheckmarxToken(checkmarxApiToken);
                String message = PluginUtils.authValidate(scanConfig, cxInstallationPath);
                return FormValidation.ok((String)message);
            }
            catch (CxException e) {
                return FormValidation.error((String)e.getMessage());
            }
            catch (Exception e) {
                return FormValidation.ok((String)("Error: " + e.getMessage()));
            }
        }

        private String getCheckmarxInstallationPath(String checkmarxInstallation) throws CheckmarxException, IOException, InterruptedException {
            if (StringUtils.isEmpty((String)checkmarxInstallation)) {
                throw new CheckmarxException("Checkmarx installation not provided");
            }
            TaskListener & Serializable taskListener = (TaskListener & Serializable)() -> System.out;
            Launcher launcher = Jenkins.get().createLauncher((TaskListener)taskListener);
            Computer computer = Arrays.stream(Jenkins.get().getComputers()).findFirst().orElseThrow(() -> new CheckmarxException("Error getting runner"));
            Node node = Optional.ofNullable(computer.getNode()).orElseThrow(() -> new CheckmarxException("Error getting runner"));
            CheckmarxInstallation cxInstallation = PluginUtils.findCheckmarxInstallation(checkmarxInstallation).forNode(node, taskListener);
            return cxInstallation.getCheckmarxExecutable(launcher);
        }

        private CheckmarxApiToken getCheckmarxApiToken(String credentialsId) throws CheckmarxException {
            CheckmarxApiToken checkmarxCredentials = (CheckmarxApiToken)CredentialsMatchers.firstOrNull((Iterable)CredentialsProvider.lookupCredentials(CheckmarxApiToken.class, (ItemGroup)Jenkins.get(), (Authentication)ACL.SYSTEM, Collections.emptyList()), (CredentialsMatcher)CredentialsMatchers.withId((String)credentialsId));
            return Optional.ofNullable(checkmarxCredentials).orElseThrow(() -> new CheckmarxException("Error getting credentials"));
        }

        public FormValidation doCheckProjectName(@QueryParameter String value) {
            if (Util.fixEmptyAndTrim((String)value) == null) {
                return FormValidation.error((String)"Project Name cannot be empty");
            }
            return FormValidation.ok();
        }

        public FormValidation doCheckBranchName(@QueryParameter String value) {
            return FormValidation.warning((String)String.format(CheckmarxScanBuilder.DEFAULT_BRANCH_WARN, CheckmarxScanBuilder.GIT_BRANCH_VAR, CheckmarxScanBuilder.CVS_BRANCH_VAR, CheckmarxScanBuilder.SVN_REVISION_VAR));
        }

        public ListBoxModel doFillCredentialsIdItems(@AncestorInPath Item item, @QueryParameter String credentialsId) {
            StandardListBoxModel result = new StandardListBoxModel();
            if (item == null ? !Jenkins.get().hasPermission(Jenkins.ADMINISTER) : !item.hasPermission(Item.EXTENDED_READ) && !item.hasPermission(CredentialsProvider.USE_ITEM)) {
                return result.includeCurrentValue(credentialsId);
            }
            return result.includeEmptyValue().includeAs(ACL.SYSTEM, item, CheckmarxApiToken.class).includeCurrentValue(credentialsId);
        }

        public FormValidation doCheckCredentialsId(@AncestorInPath Item item, @QueryParameter String value) {
            if (item == null ? !Jenkins.get().hasPermission(Jenkins.ADMINISTER) : !item.hasPermission(Item.EXTENDED_READ) && !item.hasPermission(CredentialsProvider.USE_ITEM)) {
                return FormValidation.ok();
            }
            if (Util.fixEmptyAndTrim((String)value) == null) {
                return FormValidation.error((String)"Checkmarx credentials are required.");
            }
            if (null == CredentialsMatchers.firstOrNull((Iterable)CredentialsProvider.lookupCredentials(CheckmarxApiToken.class, (ItemGroup)Jenkins.get(), (Authentication)ACL.SYSTEM, Collections.emptyList()), (CredentialsMatcher)CredentialsMatchers.anyOf((CredentialsMatcher[])new CredentialsMatcher[]{CredentialsMatchers.withId((String)value), CredentialsMatchers.instanceOf(CheckmarxApiToken.class)}))) {
                return FormValidation.error((String)"Cannot find currently selected Checkmarx credentials.");
            }
            return FormValidation.ok();
        }

        public String getCredentialsDescription() {
            if (this.getServerUrl() == null || this.getServerUrl().trim().isEmpty()) {
                return "not set";
            }
            return "Server URL: " + this.getServerUrl();
        }
    }
}

