/*
 * Decompiled with CFR 0.152.
 */
package com.checkmarx.jenkins.tools;

import com.checkmarx.jenkins.exception.CheckmarxException;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.Proxy;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.charset.StandardCharsets;
import java.util.Base64;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nullable;
import okhttp3.Authenticator;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.Response;
import okhttp3.Route;
import org.apache.commons.lang.StringUtils;

public class ProxyHttpClient {
    public OkHttpClient getHttpClient(String proxyString, int connectionTimeoutMillis, int readTimeoutMillis) throws URISyntaxException, CheckmarxException {
        OkHttpClient.Builder okClientBuilder = new OkHttpClient.Builder().connectTimeout((long)connectionTimeoutMillis, TimeUnit.MILLISECONDS).readTimeout((long)readTimeoutMillis, TimeUnit.MILLISECONDS);
        if (proxyString != null) {
            URI proxy = new URI(proxyString);
            if (ProxyHttpClient.isValidProxy(proxy.getHost(), proxy.getPort())) {
                Proxy _httpProxy = new Proxy(Proxy.Type.HTTP, new InetSocketAddress(proxy.getHost(), proxy.getPort()));
                String proxyUserInfo = proxy.getUserInfo();
                if (StringUtils.isNotEmpty((String)proxyUserInfo)) {
                    final String basicAuth = new String(Base64.getEncoder().encode(proxyUserInfo.getBytes(StandardCharsets.UTF_8)), StandardCharsets.UTF_8);
                    Authenticator _httpProxyAuth = new Authenticator(){

                        @Nullable
                        public Request authenticate(Route route, Response response) throws IOException {
                            return response.request().newBuilder().addHeader("Proxy-Authorization", "Basic " + basicAuth).build();
                        }
                    };
                    return okClientBuilder.proxyAuthenticator(_httpProxyAuth).proxy(_httpProxy).build();
                }
                return okClientBuilder.proxy(_httpProxy).build();
            }
            throw new CheckmarxException("Invalid proxy configuration");
        }
        return okClientBuilder.build();
    }

    private static boolean isValidProxy(String proxyHost, int proxyPort) {
        return StringUtils.isNotEmpty((String)proxyHost) && proxyPort >= 10 && proxyPort <= 65535;
    }
}

