/*
 * Decompiled with CFR 0.152.
 */
package com.checkmarx.jenkins.tools;

import com.checkmarx.jenkins.PluginUtils;
import com.checkmarx.jenkins.exception.CheckmarxException;
import com.checkmarx.jenkins.exception.ToolDetectionException;
import com.checkmarx.jenkins.logger.CxLoggerAdapter;
import com.checkmarx.jenkins.tools.CheckmarxInstallation;
import com.checkmarx.jenkins.tools.Platform;
import com.checkmarx.jenkins.tools.ProxyHttpClient;
import com.checkmarx.jenkins.tools.internal.DownloadService;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import hudson.Extension;
import hudson.FilePath;
import hudson.Functions;
import hudson.Util;
import hudson.model.Node;
import hudson.model.TaskListener;
import hudson.remoting.Callable;
import hudson.remoting.VirtualChannel;
import hudson.tools.ToolInstallation;
import hudson.tools.ToolInstaller;
import hudson.tools.ToolInstallerDescriptor;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.time.Instant;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import jenkins.security.MasterToSlaveCallable;
import lombok.Generated;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.Response;
import okhttp3.ResponseBody;
import org.apache.commons.compress.archivers.ArchiveEntry;
import org.apache.commons.compress.archivers.ArchiveException;
import org.apache.commons.compress.archivers.ArchiveInputStream;
import org.apache.commons.compress.archivers.ArchiveStreamFactory;
import org.apache.commons.compress.compressors.CompressorException;
import org.apache.commons.compress.compressors.CompressorInputStream;
import org.apache.commons.compress.compressors.CompressorStreamFactory;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.kohsuke.stapler.DataBoundConstructor;

public class CheckmarxInstaller
extends ToolInstaller {
    private static final String INSTALLED_FROM = ".installedFrom";
    private static final String TIMESTAMP_FILE = ".timestamp";
    public static final String cliDefaultVersion = "2.3.37";
    private static final String cliVersionFileName = "cli.version";
    private String version;
    private final Long updatePolicyIntervalHours;
    private CxLoggerAdapter log;

    @DataBoundConstructor
    public CheckmarxInstaller(String label, String version, Long updatePolicyIntervalHours) {
        super(label);
        this.version = version;
        this.updatePolicyIntervalHours = updatePolicyIntervalHours;
    }

    public FilePath performInstallation(ToolInstallation toolInstallation, Node node, TaskListener taskListener) throws IOException, InterruptedException {
        this.log = new CxLoggerAdapter(taskListener.getLogger());
        String versionToInstall = this.getVersionNumber();
        FilePath expected = this.preferredLocation(toolInstallation, node);
        if (this.isUpToDate(expected, this.log)) {
            this.log.info("Checkmarx installation is UP-TO-DATE");
            return expected;
        }
        this.log.info("Installing Checkmarx AST CLI tool (version '{}')", (Object)Util.fixEmptyAndTrim((String)versionToInstall));
        return this.installCheckmarxCliAsSingleBinary(versionToInstall, expected, node, taskListener);
    }

    public String getVersionNumber() {
        if ("latest".equalsIgnoreCase(this.version.trim()) || this.version.isEmpty()) {
            return this.readCLILatestVersionFromVersionFile();
        }
        return this.version;
    }

    public String readCLILatestVersionFromVersionFile() {
        try {
            Path versionFilePath = CheckmarxInstaller.findVersionFilePath().orElseThrow(() -> new ToolDetectionException("Could not find version file"));
            String fileVersion = Files.readString(versionFilePath.resolve(cliVersionFileName)).trim();
            return StringUtils.isNotEmpty((String)fileVersion) ? fileVersion : cliDefaultVersion;
        }
        catch (IOException e) {
            return cliDefaultVersion;
        }
    }

    public static Optional<Path> findVersionFilePath() {
        for (Path dir = Paths.get("", new String[0]).toAbsolutePath(); dir != null; dir = dir.getParent()) {
            if (!Files.exists(dir.resolve(cliVersionFileName), new LinkOption[0])) continue;
            return Optional.of(dir);
        }
        return Optional.empty();
    }

    private boolean isUpToDate(FilePath expectedLocation, CxLoggerAdapter log) throws IOException, InterruptedException {
        long timestampFromFile;
        FilePath marker = expectedLocation.child(TIMESTAMP_FILE);
        if (!marker.exists()) {
            return false;
        }
        String content = StringUtils.chomp((String)marker.readToString());
        try {
            timestampFromFile = Long.parseLong(content);
        }
        catch (NumberFormatException ex) {
            log.error(".timestamp file is corrupt and cannot be read and will be reset to 0.");
            timestampFromFile = 0L;
        }
        long timestampNow = Instant.now().toEpochMilli();
        long timestampDifference = timestampNow - timestampFromFile;
        if (timestampDifference <= 0L) {
            return true;
        }
        long updateInterval = TimeUnit.HOURS.toMillis(this.updatePolicyIntervalHours);
        return timestampDifference < updateInterval;
    }

    private FilePath installCheckmarxCliAsSingleBinary(String version, FilePath expected, Node node, TaskListener log) throws IOException, InterruptedException {
        VirtualChannel nodeChannel = node.getChannel();
        if (nodeChannel == null) {
            throw new IOException(String.format("Node '%s' is offline", node.getDisplayName()));
        }
        Platform platform = (Platform)((Object)nodeChannel.call((Callable)new GetPlatform(node.getDisplayName())));
        try {
            String proxyStr = PluginUtils.getProxy();
            if (StringUtils.isNotEmpty((String)proxyStr)) {
                log.getLogger().println("Installer using proxy: " + proxyStr);
            }
            URL checkmarxDownloadUrl = DownloadService.getDownloadUrlForCli(version, platform);
            expected.mkdirs();
            nodeChannel.call((Callable)new Downloader(checkmarxDownloadUrl, proxyStr, expected.child(DownloadService.buildFileName(version, platform)), expected.child(platform.checkmarxWrapperFileName)));
            expected.child(INSTALLED_FROM).write(checkmarxDownloadUrl.toString(), StandardCharsets.UTF_8.name());
            expected.child(TIMESTAMP_FILE).write(String.valueOf(Instant.now().toEpochMilli()), StandardCharsets.UTF_8.name());
        }
        catch (Exception ex) {
            log.getLogger().println("Checkmarx Security tool could not installed: " + ex.getMessage());
            throw new ToolDetectionException("Could not install Checkmarx CLI from binary", ex);
        }
        return expected;
    }

    @Generated
    public String getVersion() {
        return this.version;
    }

    @Generated
    public Long getUpdatePolicyIntervalHours() {
        return this.updatePolicyIntervalHours;
    }

    private static class Downloader
    extends MasterToSlaveCallable<Void, IOException> {
        private static final long serialVersionUID = 1L;
        private final URL downloadUrl;
        private final FilePath output;
        private final FilePath executableFile;
        private final String proxy;

        Downloader(URL downloadUrl, String proxy, FilePath output, FilePath executableFile) {
            this.downloadUrl = downloadUrl;
            this.output = output;
            this.executableFile = executableFile;
            this.proxy = proxy;
        }

        public Void call() throws IOException {
            boolean result;
            File downloadedFile = new File(this.output.getRemote());
            try {
                Downloader.copyURLToFile(this.downloadUrl, this.proxy, downloadedFile, 10000, 10000);
                Downloader.extract(downloadedFile.getAbsolutePath(), downloadedFile.getParent());
            }
            catch (ArchiveException | CompressorException e) {
                throw new IOException(String.format("Could not extract cli: %s", downloadedFile.getAbsolutePath()));
            }
            catch (CheckmarxException | URISyntaxException e) {
                throw new RuntimeException(e);
            }
            File cxExecutable = new File(this.executableFile.getRemote());
            if (!Functions.isWindows() && cxExecutable.isFile() && !(result = cxExecutable.setExecutable(true, false))) {
                throw new IOException(String.format("Could not set executable flag for the file: %s", downloadedFile.getAbsolutePath()));
            }
            return null;
        }

        @SuppressFBWarnings(value={"NP_NULL_ON_SOME_PATH_FROM_RETURN_VALUE"})
        public static void copyURLToFile(URL source, String proxyStr, File destination, int connectionTimeoutMillis, int readTimeoutMillis) throws IOException, URISyntaxException, CheckmarxException {
            OkHttpClient client = new ProxyHttpClient().getHttpClient(proxyStr, connectionTimeoutMillis, readTimeoutMillis);
            Request request = new Request.Builder().url(source).build();
            Response response = client.newCall(request).execute();
            ResponseBody responseBody = response.body();
            try (InputStream stream = responseBody.byteStream();){
                FileUtils.copyInputStreamToFile((InputStream)stream, (File)destination);
            }
        }

        public static void extract(String srcFile, String dest) throws ArchiveException, IOException, CompressorException {
            ArchiveEntry nextEntry;
            boolean outputFileExisted;
            FileInputStream fileInputStream = new FileInputStream(srcFile);
            ArchiveInputStream archiveInputStream = Downloader.generateArchiveInputStream(fileInputStream, srcFile);
            File outputFile = new File(dest);
            boolean bl = outputFileExisted = outputFile.exists() || outputFile.mkdirs();
            if (!outputFileExisted) {
                throw new IOException("Unable to create path");
            }
            while ((nextEntry = archiveInputStream.getNextEntry()) != null) {
                File tempFile = new File(dest, nextEntry.getName());
                if (nextEntry.isDirectory()) {
                    boolean folderExisted = tempFile.exists() || tempFile.mkdirs();
                    if (folderExisted) continue;
                    throw new IOException("Unable to create path");
                }
                FileOutputStream fos = FileUtils.openOutputStream((File)tempFile);
                IOUtils.copy((InputStream)archiveInputStream, (OutputStream)fos);
                fos.close();
            }
            archiveInputStream.close();
            fileInputStream.close();
        }

        private static ArchiveInputStream generateArchiveInputStream(FileInputStream fis, String srcFile) throws ArchiveException, CompressorException {
            String extension = FilenameUtils.getExtension((String)srcFile);
            ArchiveStreamFactory asf = new ArchiveStreamFactory();
            if (extension.toLowerCase().endsWith("tgz") || extension.toLowerCase().endsWith("gz")) {
                CompressorInputStream cis = new CompressorStreamFactory().createCompressorInputStream("gz", (InputStream)new BufferedInputStream(fis));
                return asf.createArchiveInputStream((InputStream)new BufferedInputStream((InputStream)cis));
            }
            return asf.createArchiveInputStream((InputStream)new BufferedInputStream(fis));
        }
    }

    private static class GetPlatform
    extends MasterToSlaveCallable<Platform, IOException> {
        private static final long serialVersionUID = 1L;
        private final String nodeDisplayName;

        GetPlatform(String nodeDisplayName) {
            this.nodeDisplayName = nodeDisplayName;
        }

        public Platform call() throws IOException {
            try {
                return Platform.current();
            }
            catch (ToolDetectionException ex) {
                throw new IOException(String.format("Could not determine platform on node %s", this.nodeDisplayName));
            }
        }
    }

    @Extension
    public static final class CheckmarxInstallerDescriptor
    extends ToolInstallerDescriptor<CheckmarxInstaller> {
        public String getDisplayName() {
            return "Install from checkmarx.com";
        }

        public boolean isApplicable(Class<? extends ToolInstallation> toolType) {
            return toolType == CheckmarxInstallation.class;
        }
    }
}

