/*
 * Decompiled with CFR 0.152.
 */
package com.checkmarx.jenkins;

import com.checkmarx.ast.results.ResultsSummary;
import com.checkmarx.jenkins.PluginUtils;
import com.checkmarx.jenkins.tools.ProxyHttpClient;
import com.fasterxml.jackson.databind.ObjectMapper;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import hudson.model.Run;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.Paths;
import jenkins.model.Jenkins;
import jenkins.model.RunAction2;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.Response;
import okhttp3.ResponseBody;
import org.apache.commons.io.IOUtils;

public class CheckmarxScanResultsAction
implements RunAction2 {
    private transient Run<?, ?> run;

    public Run getRun() {
        return this.run;
    }

    public void onAttached(Run<?, ?> run) {
        this.run = run;
    }

    public void onLoad(Run<?, ?> run) {
        this.run = run;
    }

    public String getIconFileName() {
        return "/plugin/checkmarx-ast-scanner/images/CxIcon24x24.png";
    }

    public String getDisplayName() {
        return "Checkmarx Scan Results";
    }

    public String getUrlName() {
        return "scanResults";
    }

    @SuppressFBWarnings(value={"NP_NULL_ON_SOME_PATH_FROM_RETURN_VALUE"})
    public ResultsSummary getResultsSummary() {
        for (Object artifact : this.run.getArtifacts()) {
            if (!(artifact instanceof Run.Artifact) || !((Run.Artifact)artifact).getFileName().contains("checkmarx-ast-results.json")) continue;
            try {
                String artifactHref = ((Run.Artifact)artifact).getHref();
                String serverUrl = Jenkins.get().getRootUrl();
                String fullUrl = serverUrl + this.run.getUrl() + "artifact/" + artifactHref;
                OkHttpClient client = new ProxyHttpClient().getHttpClient(PluginUtils.getProxy(), 10000, 10000);
                Request request = new Request.Builder().url(fullUrl).build();
                Response response = client.newCall(request).execute();
                ResponseBody responseBody = response.body();
                InputStream stream = responseBody.byteStream();
                String json = IOUtils.toString((InputStream)stream);
                ObjectMapper objectMapper = new ObjectMapper();
                return (ResultsSummary)objectMapper.readValue(json, ResultsSummary.class);
            }
            catch (Exception e) {
                e.printStackTrace();
                try {
                    byte[] encoded = Files.readAllBytes(Paths.get(((Run.Artifact)artifact).getFile().getCanonicalPath(), new String[0]));
                    String json = new String(encoded, Charset.defaultCharset());
                    ObjectMapper objectMapper = new ObjectMapper();
                    return (ResultsSummary)objectMapper.readValue(json, ResultsSummary.class);
                }
                catch (Exception e1) {
                    e1.printStackTrace();
                }
            }
        }
        return null;
    }
}

