/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.jenkins.ec2fleet;

import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.stream.Collectors;
import jenkins.model.Jenkins;
import org.apache.commons.lang.RandomStringUtils;

public class CloudNames {
    public static final int SUFFIX_LENGTH = 8;
    private static final Set<String> usedSuffixes = new HashSet<String>();

    public static Boolean isUnique(String name) {
        return !Jenkins.get().clouds.stream().anyMatch(c -> c.name.equals(name));
    }

    public static Boolean isDuplicated(String name) {
        return Jenkins.get().clouds.stream().filter(c -> c.name.equals(name)).count() > 1L;
    }

    public static String generateUnique(String proposedName) {
        Set usedNames;
        Set set = usedNames = Jenkins.get().clouds != null ? Jenkins.get().clouds.stream().map(c -> c.name).collect(Collectors.toSet()) : Collections.emptySet();
        if (proposedName.equals("FleetCloud") || proposedName.equals("FleetCloudLabel") || usedNames.contains(proposedName)) {
            return proposedName + "-" + CloudNames.generateSuffix();
        }
        return proposedName;
    }

    private static String generateSuffix() {
        String suffix;
        while (usedSuffixes.contains(suffix = RandomStringUtils.randomAlphanumeric((int)8))) {
        }
        usedSuffixes.add(suffix);
        return suffix;
    }
}

