/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.jenkins.ec2fleet;

import com.amazon.jenkins.ec2fleet.AbstractEC2FleetCloud;
import com.amazon.jenkins.ec2fleet.CloudNames;
import com.amazon.jenkins.ec2fleet.EC2AgentTerminationReason;
import com.amazon.jenkins.ec2fleet.EC2FleetAutoResubmitComputerLauncher;
import com.amazon.jenkins.ec2fleet.EC2FleetNode;
import com.amazon.jenkins.ec2fleet.EC2FleetNodeComputer;
import com.amazon.jenkins.ec2fleet.EC2FleetOnlineChecker;
import com.amazon.jenkins.ec2fleet.EC2RetentionStrategy;
import com.amazon.jenkins.ec2fleet.FleetStateStats;
import com.amazon.jenkins.ec2fleet.Registry;
import com.amazon.jenkins.ec2fleet.aws.AwsPermissionChecker;
import com.amazon.jenkins.ec2fleet.aws.RegionHelper;
import com.amazon.jenkins.ec2fleet.fleet.AutoScalingGroupFleet;
import com.amazon.jenkins.ec2fleet.fleet.EC2Fleet;
import com.amazon.jenkins.ec2fleet.fleet.EC2Fleets;
import com.cloudbees.jenkins.plugins.awscredentials.AWSCredentialsHelper;
import com.google.common.collect.Sets;
import hudson.Extension;
import hudson.ExtensionPoint;
import hudson.model.AbstractDescribableImpl;
import hudson.model.Computer;
import hudson.model.Descriptor;
import hudson.model.Failure;
import hudson.model.ItemGroup;
import hudson.model.Label;
import hudson.model.Node;
import hudson.model.Queue;
import hudson.model.TaskListener;
import hudson.slaves.Cloud;
import hudson.slaves.ComputerConnector;
import hudson.slaves.ComputerLauncher;
import hudson.slaves.NodeProvisioner;
import hudson.util.FormValidation;
import hudson.util.ListBoxModel;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.logging.SimpleFormatter;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import jenkins.model.Jenkins;
import net.sf.json.JSONObject;
import org.apache.commons.lang.StringUtils;
import org.jenkinsci.Symbol;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.DataBoundSetter;
import org.kohsuke.stapler.QueryParameter;
import org.kohsuke.stapler.StaplerRequest2;
import software.amazon.awssdk.services.ec2.Ec2Client;
import software.amazon.awssdk.services.ec2.model.DescribeInstanceTypesRequest;
import software.amazon.awssdk.services.ec2.model.DescribeInstanceTypesResponse;
import software.amazon.awssdk.services.ec2.model.Instance;
import software.amazon.awssdk.services.ec2.model.InstanceStateName;
import software.amazon.awssdk.services.ec2.model.InstanceType;
import software.amazon.awssdk.services.ec2.model.InstanceTypeInfo;

public class EC2FleetCloud
extends AbstractEC2FleetCloud {
    public static final String EC2_INSTANCE_TAG_NAMESPACE = "ec2-fleet-plugin";
    public static final String EC2_INSTANCE_CLOUD_NAME_TAG = "ec2-fleet-plugin:cloud-name";
    public static final String BASE_DEFAULT_FLEET_CLOUD_ID = "FleetCloud";
    public static final int DEFAULT_CLOUD_STATUS_INTERVAL_SEC = 10;
    private static final int DEFAULT_INIT_ONLINE_TIMEOUT_SEC = 180;
    private static final int DEFAULT_INIT_ONLINE_CHECK_INTERVAL_SEC = 15;
    private static final int DEFAULT_MAX_TOTAL_USES = -1;
    private static final SimpleFormatter sf = new SimpleFormatter();
    private static final Logger LOGGER = Logger.getLogger(EC2FleetCloud.class.getName());
    private static final ScheduledExecutorService EXECUTOR = Executors.newSingleThreadScheduledExecutor();
    @Deprecated
    private final String credentialsId;
    private final String awsCredentialsId;
    private final String region;
    private final String endpoint;
    private final String fleet;
    private final String fsRoot;
    private final ComputerConnector computerConnector;
    private final boolean privateIpUsed;
    private final boolean alwaysReconnect;
    private final String labelString;
    private final Integer idleMinutes;
    private final int minSize;
    private final int maxSize;
    private final int minSpareSize;
    private final int numExecutors;
    private final boolean addNodeOnlyIfRunning;
    private final boolean restrictUsage;
    private final boolean scaleExecutorsByWeight;
    private final ExecutorScaler executorScaler;
    private final Integer initOnlineTimeoutSec;
    private final Integer initOnlineCheckIntervalSec;
    private final Integer cloudStatusIntervalSec;
    private final Integer maxTotalUses;
    private final boolean disableTaskResubmit;
    private final boolean noDelayProvision;
    private transient FleetStateStats stats;
    private transient int toAdd;
    private transient Map<String, EC2AgentTerminationReason> instanceIdsToTerminate;
    private transient Set<NodeProvisioner.PlannedNode> plannedNodesCache;
    private transient ArrayList<ScheduledFuture<?>> plannedNodeScheduledFutures;
    private transient AtomicInteger plannedNodeCounter = new AtomicInteger(1);

    @DataBoundConstructor
    public EC2FleetCloud(@Nonnull String name, String awsCredentialsId, @Deprecated String credentialsId, String region, String endpoint, String fleet, String labelString, String fsRoot, ComputerConnector computerConnector, boolean privateIpUsed, boolean alwaysReconnect, Integer idleMinutes, int minSize, int maxSize, int minSpareSize, int numExecutors, boolean addNodeOnlyIfRunning, boolean restrictUsage, String maxTotalUses, boolean disableTaskResubmit, Integer initOnlineTimeoutSec, Integer initOnlineCheckIntervalSec, Integer cloudStatusIntervalSec, boolean noDelayProvision, boolean scaleExecutorsByWeight, ExecutorScaler executorScaler) {
        super(StringUtils.isNotBlank((String)name) ? name : CloudNames.generateUnique(BASE_DEFAULT_FLEET_CLOUD_ID));
        this.init();
        this.credentialsId = credentialsId;
        this.awsCredentialsId = awsCredentialsId;
        this.region = region;
        this.endpoint = endpoint;
        this.fleet = fleet;
        this.fsRoot = fsRoot;
        this.computerConnector = computerConnector;
        this.labelString = labelString;
        this.idleMinutes = idleMinutes;
        this.privateIpUsed = privateIpUsed;
        this.alwaysReconnect = alwaysReconnect;
        if (minSize < 0) {
            this.warning("Cloud parameter 'minSize' can't be less than 0, setting to 0", new Object[0]);
        }
        this.minSize = Math.max(0, minSize);
        this.maxSize = maxSize;
        this.minSpareSize = Math.max(0, minSpareSize);
        this.maxTotalUses = StringUtils.isBlank((String)maxTotalUses) ? -1 : Integer.parseInt(maxTotalUses);
        this.numExecutors = Math.max(numExecutors, 1);
        this.addNodeOnlyIfRunning = addNodeOnlyIfRunning;
        this.restrictUsage = restrictUsage;
        this.disableTaskResubmit = disableTaskResubmit;
        this.initOnlineTimeoutSec = initOnlineTimeoutSec;
        this.initOnlineCheckIntervalSec = initOnlineCheckIntervalSec;
        this.cloudStatusIntervalSec = cloudStatusIntervalSec;
        this.noDelayProvision = noDelayProvision;
        this.scaleExecutorsByWeight = scaleExecutorsByWeight;
        ExecutorScaler executorScaler2 = this.executorScaler = executorScaler == null ? new NoScaler().withNumExecutors(this.numExecutors) : executorScaler.withNumExecutors(this.numExecutors);
        if (fleet != null) {
            this.stats = EC2Fleets.get(fleet).getState(this.getAwsCredentialsId(), region, endpoint, this.getFleet());
        }
    }

    public boolean isNoDelayProvision() {
        return this.noDelayProvision;
    }

    public String getAwsCredentialsId() {
        return StringUtils.isNotBlank((String)this.awsCredentialsId) ? this.awsCredentialsId : this.credentialsId;
    }

    @Override
    public boolean isDisableTaskResubmit() {
        return this.disableTaskResubmit;
    }

    public int getInitOnlineTimeoutSec() {
        return this.initOnlineTimeoutSec == null ? 180 : this.initOnlineTimeoutSec;
    }

    public int getScheduledFutureTimeoutSec() {
        return this.getCloudStatusIntervalSec() * 3;
    }

    public int getCloudStatusIntervalSec() {
        return this.cloudStatusIntervalSec == null ? 10 : this.cloudStatusIntervalSec;
    }

    public int getInitOnlineCheckIntervalSec() {
        return this.initOnlineCheckIntervalSec == null ? 15 : this.initOnlineCheckIntervalSec;
    }

    public String getRegion() {
        return this.region;
    }

    public String getEndpoint() {
        return this.endpoint;
    }

    public String getFleet() {
        return this.fleet;
    }

    public String getFsRoot() {
        return this.fsRoot;
    }

    public boolean isAddNodeOnlyIfRunning() {
        return this.addNodeOnlyIfRunning;
    }

    public ComputerConnector getComputerConnector() {
        return this.computerConnector;
    }

    public boolean isPrivateIpUsed() {
        return this.privateIpUsed;
    }

    @Override
    public boolean isAlwaysReconnect() {
        return this.alwaysReconnect;
    }

    public String getLabelString() {
        return this.labelString;
    }

    @Override
    public int getIdleMinutes() {
        return this.idleMinutes != null ? this.idleMinutes : 0;
    }

    public int getMaxSize() {
        return this.maxSize;
    }

    public int getMinSize() {
        return this.minSize;
    }

    public int getMinSpareSize() {
        return this.minSpareSize;
    }

    public int getMaxTotalUses() {
        return this.maxTotalUses;
    }

    public int getNumExecutors() {
        return this.numExecutors;
    }

    public boolean isScaleExecutorsByWeight() {
        return this.scaleExecutorsByWeight;
    }

    public ExecutorScaler getExecutorScaler() {
        return this.executorScaler;
    }

    public String getJvmSettings() {
        return "";
    }

    public boolean isRestrictUsage() {
        return this.restrictUsage;
    }

    synchronized Set<NodeProvisioner.PlannedNode> getPlannedNodesCache() {
        return this.plannedNodesCache;
    }

    synchronized ArrayList<ScheduledFuture<?>> getPlannedNodeScheduledFutures() {
        return this.plannedNodeScheduledFutures;
    }

    synchronized void setPlannedNodeScheduledFutures(ArrayList<ScheduledFuture<?>> futures) {
        this.plannedNodeScheduledFutures = futures;
    }

    synchronized Map<String, EC2AgentTerminationReason> getInstanceIdsToTerminate() {
        return this.instanceIdsToTerminate;
    }

    synchronized int getToAdd() {
        return this.toAdd;
    }

    synchronized FleetStateStats getStats() {
        return this.stats;
    }

    synchronized void setStats(FleetStateStats stats) {
        this.stats = stats;
    }

    public boolean hasUnlimitedUsesForNodes() {
        return this.maxTotalUses == -1;
    }

    @Override
    public synchronized boolean hasExcessCapacity() {
        if (this.stats == null) {
            return false;
        }
        if (this.stats.getNumDesired() - this.instanceIdsToTerminate.size() > this.maxSize) {
            this.info("Fleet has excess capacity of %s more than the max allowed: %s", this.stats.getNumDesired() - this.instanceIdsToTerminate.size(), this.maxSize);
            return true;
        }
        return false;
    }

    private synchronized int getNextPlannedNodeCounter() {
        if (this.plannedNodeCounter == null) {
            this.plannedNodeCounter = new AtomicInteger(1);
        }
        return this.plannedNodeCounter.getAndIncrement();
    }

    public synchronized Collection<NodeProvisioner.PlannedNode> provision(@Nonnull Cloud.CloudState cloudState, int excessWorkload) {
        Jenkins jenkinsInstance = Jenkins.get();
        if (jenkinsInstance.isQuietingDown()) {
            LOGGER.log(Level.FINE, "Not provisioning nodes, Jenkins instance is quieting down");
            return Collections.emptyList();
        }
        if (jenkinsInstance.isTerminating()) {
            LOGGER.log(Level.FINE, "Not provisioning nodes, Jenkins instance is terminating");
            return Collections.emptyList();
        }
        this.fine("excessWorkload %s", excessWorkload);
        if (this.stats == null) {
            this.info("First update not completed, still setting configuring cloud state. Skipping provision", new Object[0]);
            return Collections.emptyList();
        }
        int cap = this.stats.getNumDesired() + this.toAdd;
        if (cap >= this.getMaxSize()) {
            this.info("Max instance size '%s' reached. Skipping provision", this.getMaxSize());
            return Collections.emptyList();
        }
        if (!this.stats.getState().isActive()) {
            this.info("Fleet is in a non-active state '%s'. Skipping provision", this.stats.getState().getDetailed());
            return Collections.emptyList();
        }
        int numExecutors1 = this.numExecutors == 0 ? 1 : this.numExecutors;
        int weightedExcessWorkload = (excessWorkload + numExecutors1 - 1) / numExecutors1;
        int targetCapacity = Math.min(cap + weightedExcessWorkload, this.getMaxSize());
        int toProvision = targetCapacity - cap;
        this.fine("to provision = %s", toProvision);
        if (toProvision < 1) {
            this.info("toProvision is less than 1. Skipping provision", new Object[0]);
            return Collections.emptyList();
        }
        this.toAdd += toProvision;
        ArrayList<NodeProvisioner.PlannedNode> resultList = new ArrayList<NodeProvisioner.PlannedNode>();
        for (int f = 0; f < toProvision; ++f) {
            CompletableFuture completableFuture = new CompletableFuture();
            NodeProvisioner.PlannedNode plannedNode = new NodeProvisioner.PlannedNode(String.format("FleetNode-%s-%d", this.getDisplayName(), this.getNextPlannedNodeCounter()), completableFuture, this.numExecutors);
            resultList.add(plannedNode);
            this.plannedNodesCache.add(plannedNode);
            ScheduledFuture<?> scheduledFuture = EXECUTOR.schedule(() -> {
                if (completableFuture.isDone()) {
                    return;
                }
                this.info("Scaling timeout reached, removing node from Jenkins's plannedCapacitySnapshot", new Object[0]);
                completableFuture.complete(null);
            }, (long)this.getScheduledFutureTimeoutSec(), TimeUnit.SECONDS);
            this.plannedNodeScheduledFutures.add(scheduledFuture);
        }
        return resultList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FleetStateStats update() {
        Map<String, EC2AgentTerminationReason> currentInstanceIdsToTerminate;
        int currentToAdd;
        this.fine("start cloud %s", new Object[]{this});
        FleetStateStats currentState = EC2Fleets.get(this.fleet).getState(this.getAwsCredentialsId(), this.region, this.endpoint, this.getFleet());
        if (currentState.getState().isModifying()) {
            this.info("Fleet '%s' is currently under modification. Skipping update", currentState.getFleetId());
            EC2FleetCloud eC2FleetCloud = this;
            synchronized (eC2FleetCloud) {
                return this.stats;
            }
        }
        EC2FleetCloud eC2FleetCloud = this;
        synchronized (eC2FleetCloud) {
            if (this.minSpareSize > 0) {
                int currentSpareInstanceCount = this.getCurrentSpareInstanceCount(currentState, currentState.getNumDesired());
                int additionalSpareInstancesRequired = this.minSpareSize - currentSpareInstanceCount;
                this.fine("currentSpareInstanceCount: %s additionalSpareInstancesRequired: %s", currentSpareInstanceCount, additionalSpareInstancesRequired);
                if (additionalSpareInstancesRequired > 0) {
                    this.toAdd += additionalSpareInstancesRequired;
                }
            }
            currentToAdd = this.toAdd;
            currentInstanceIdsToTerminate = this.filterOutBusyNodes();
        }
        currentState = this.updateByState(currentToAdd, currentInstanceIdsToTerminate, currentState);
        eC2FleetCloud = this;
        synchronized (eC2FleetCloud) {
            this.instanceIdsToTerminate.keySet().removeAll(currentInstanceIdsToTerminate.keySet());
            this.toAdd -= currentToAdd;
            this.fine("setting stats", new Object[0]);
            this.stats = currentState;
            this.removePlannedNodeScheduledFutures(currentToAdd);
            int updatedTargetCapacity = Math.max(0, this.stats.getNumDesired() - this.instanceIdsToTerminate.size() + this.toAdd);
            while (this.plannedNodesCache.size() > updatedTargetCapacity) {
                this.info("Planned number of nodes '%s' is greater than the targetCapacity '%s'. Canceling a node", this.plannedNodesCache.size(), updatedTargetCapacity);
                Iterator<NodeProvisioner.PlannedNode> iterator = this.plannedNodesCache.iterator();
                NodeProvisioner.PlannedNode plannedNodeToCancel = iterator.next();
                iterator.remove();
                plannedNodeToCancel.future.cancel(true);
            }
            return this.stats;
        }
    }

    private Map<String, EC2AgentTerminationReason> filterOutBusyNodes() {
        Jenkins j = Jenkins.get();
        Map<String, EC2AgentTerminationReason> filteredInstanceIdsToTerminate = this.instanceIdsToTerminate.entrySet().stream().filter(e -> {
            Computer c = j.getComputer((String)e.getKey());
            return c == null || c.isIdle();
        }).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
        Sets.SetView filteredOutNonIdleIds = Sets.difference(this.instanceIdsToTerminate.keySet(), filteredInstanceIdsToTerminate.keySet());
        if (filteredOutNonIdleIds.size() > 0) {
            this.info("Skipping termination of the following instances until the next update cycle, as they are still busy doing some work: %s.", filteredOutNonIdleIds);
        }
        return filteredInstanceIdsToTerminate;
    }

    public boolean removePlannedNodeScheduledFutures(int numToRemove) {
        if (numToRemove < 1) {
            return false;
        }
        Iterator<ScheduledFuture<?>> iterator = this.plannedNodeScheduledFutures.iterator();
        for (int i = 0; i < numToRemove; ++i) {
            if (!iterator.hasNext()) {
                this.fine("Expected a scheduled future to exist but no more are present", new Object[0]);
                return false;
            }
            ScheduledFuture<?> nextFuture = iterator.next();
            nextFuture.cancel(true);
            iterator.remove();
        }
        return true;
    }

    private FleetStateStats updateByState(int currentToAdd, final Map<String, EC2AgentTerminationReason> currentInstanceIdsToTerminate, FleetStateStats currentState) {
        final Jenkins jenkins = Jenkins.get();
        final Ec2Client ec2 = Registry.getEc2Api().connect(this.getAwsCredentialsId(), this.region, this.endpoint);
        int targetCapacity = Math.max(this.minSize, Math.min(this.maxSize, currentState.getNumDesired() - currentInstanceIdsToTerminate.size() + currentToAdd));
        if (currentToAdd > 0 || currentInstanceIdsToTerminate.size() > 0 || targetCapacity != currentState.getNumDesired()) {
            EC2Fleets.get(this.fleet).modify(this.getAwsCredentialsId(), this.region, this.endpoint, this.fleet, targetCapacity, this.minSize, this.maxSize);
            this.info("Set target capacity to '%s'", targetCapacity);
        }
        final FleetStateStats updatedState = new FleetStateStats(currentState, targetCapacity);
        if (currentInstanceIdsToTerminate.size() > 0) {
            Queue.withLock((Runnable)new Runnable(){

                @Override
                public void run() {
                    EC2FleetCloud.this.info("Removing Jenkins nodes before terminating corresponding EC2 instances", new Object[0]);
                    for (String instanceId : currentInstanceIdsToTerminate.keySet()) {
                        Node node = jenkins.getNode(instanceId);
                        if (node == null) continue;
                        try {
                            jenkins.removeNode(node);
                        }
                        catch (IOException e) {
                            EC2FleetCloud.this.warning("Failed to remove node '%s' from Jenkins before termination.", instanceId);
                        }
                    }
                }
            });
            if (EC2Fleets.get(this.fleet).isAutoScalingGroup().booleanValue()) {
                this.fine("Removing scale-in protection from instances in AutoScalingGroup: %s", currentInstanceIdsToTerminate.keySet());
                ((AutoScalingGroupFleet)EC2Fleets.get(this.fleet)).removeScaleInProtection(this.awsCredentialsId, this.region, this.endpoint, this.fleet, currentInstanceIdsToTerminate.keySet());
                this.info("Removed scale-in protection from instances (ASG will terminate them): %s", currentInstanceIdsToTerminate);
            } else {
                this.fine("Terminating instances: %s", currentInstanceIdsToTerminate.keySet());
                Registry.getEc2Api().terminateInstances(ec2, currentInstanceIdsToTerminate.keySet());
                this.info("Terminated instances: %s", currentInstanceIdsToTerminate);
            }
        }
        this.fine("Fleet instances: %s", updatedState.getInstances());
        HashSet<String> fleetInstances = new HashSet<String>(updatedState.getInstances());
        Map<String, Instance> described = Registry.getEc2Api().describeInstances(ec2, fleetInstances);
        described.keySet().removeAll(currentInstanceIdsToTerminate.keySet());
        this.fine("Described instances: %s", described.keySet());
        updatedState.setNumActive(described.size());
        HashSet<String> jenkinsInstances = new HashSet<String>();
        for (Node node : jenkins.getNodes()) {
            if (!(node instanceof EC2FleetNode) || !((EC2FleetCloud)((EC2FleetNode)node).getCloud()).getFleet().equals(this.fleet)) continue;
            jenkinsInstances.add(node.getNodeName());
        }
        this.fine("Jenkins nodes: %s", jenkinsInstances);
        HashSet jenkinsNodesWithoutInstance = new HashSet(jenkinsInstances);
        jenkinsNodesWithoutInstance.removeAll(fleetInstances);
        if (!jenkinsNodesWithoutInstance.isEmpty()) {
            this.fine("Jenkins nodes without instance(s): %s", jenkinsNodesWithoutInstance);
        }
        HashSet<String> terminatedFleetInstances = new HashSet<String>(fleetInstances);
        terminatedFleetInstances.removeAll(described.keySet());
        if (!terminatedFleetInstances.isEmpty()) {
            this.fine("Terminated Fleet instance(s): %s", terminatedFleetInstances);
        }
        final HashMap<String, Instance> newFleetInstances = new HashMap<String, Instance>(described);
        for (String string : jenkinsInstances) {
            newFleetInstances.remove(string);
        }
        if (!newFleetInstances.isEmpty()) {
            this.fine("New instance(s) not yet registered as nodes in Jenkins: %s ", newFleetInstances.keySet());
        }
        ArrayList<String> jenkinsNodesToRemove = new ArrayList<String>();
        jenkinsNodesToRemove.addAll(terminatedFleetInstances);
        jenkinsNodesToRemove.addAll(jenkinsNodesWithoutInstance);
        for (String instance : jenkinsNodesToRemove) {
            this.removeNode(instance);
        }
        for (String instanceId : jenkinsInstances) {
            Node node = jenkins.getNode(instanceId);
            if (node == null) {
                this.info("Skipping label update, the Jenkins node for instance '%s' was null", instanceId);
                continue;
            }
            if (this.labelString.equals(node.getLabelString())) continue;
            try {
                this.info("Updating label on node '%s' to \"%s\".", instanceId, this.labelString);
                node.setLabelString(this.labelString);
            }
            catch (Exception ex) {
                this.warning(ex, "Failed to set label on node '%s': ", instanceId, ex.toString());
            }
        }
        if (newFleetInstances.size() > 0) {
            try {
                Registry.getEc2Api().tagInstances(ec2, newFleetInstances.keySet(), EC2_INSTANCE_CLOUD_NAME_TAG, this.name);
            }
            catch (Exception exception) {
                this.warning(exception, "Failed to tag new instances: %s", newFleetInstances.keySet());
            }
            Queue.withLock((Runnable)new Runnable(){

                @Override
                public void run() {
                    try {
                        for (Instance instance : newFleetInstances.values()) {
                            EC2FleetCloud.this.addNewAgent(ec2, instance, updatedState);
                        }
                    }
                    catch (Exception ex) {
                        EC2FleetCloud.this.warning(ex, "Unable to set label on node", new Object[0]);
                    }
                }
            });
        }
        return updatedState;
    }

    @Override
    public synchronized boolean scheduleToTerminate(String instanceId, boolean ignoreMinConstraints, EC2AgentTerminationReason reason) {
        if (this.stats == null) {
            this.info("First update not done, skipping termination scheduling for '%s'", instanceId);
            return false;
        }
        if (!ignoreMinConstraints) {
            int currentSpareInstanceCount;
            if (this.minSize > 0 && this.stats.getNumActive() - this.instanceIdsToTerminate.size() <= this.minSize) {
                this.info("Not scheduling instance '%s' for termination because we need a minimum of %s instance(s) running", instanceId, this.minSize);
                this.fine("cloud: %s, instanceIdsToTerminate: %s", new Object[]{this, this.instanceIdsToTerminate});
                return false;
            }
            if (this.minSpareSize > 0 && (currentSpareInstanceCount = this.getCurrentSpareInstanceCount(this.stats, this.stats.getNumActive())) - this.instanceIdsToTerminate.size() <= this.minSpareSize) {
                this.info("Not scheduling instance '%s' for termination because we need a minimum of %s spare instance(s) running", instanceId, this.minSpareSize);
                return false;
            }
        }
        this.info("Scheduling instance '%s' for termination on cloud %s because of reason: %s", new Object[]{instanceId, this, reason});
        this.instanceIdsToTerminate.put(instanceId, reason);
        this.fine("InstanceIdsToTerminate: %s", this.instanceIdsToTerminate);
        return true;
    }

    public boolean canProvision(Cloud.CloudState cloudState) {
        Label label = cloudState.getLabel();
        if (this.fleet == null) {
            this.fine("Fleet/ASG for cloud is null, returning false", new Object[0]);
            return false;
        }
        if (this.restrictUsage && this.labelString != null && label == null) {
            this.fine("RestrictUsage is enabled while label is null, returning false", new Object[0]);
            return false;
        }
        if (label != null && !Label.parse((String)this.labelString).containsAll(label.listAtoms())) {
            this.finer("Label '%s' not found within Fleet's labels '%s', returning false", label, this.labelString);
            return false;
        }
        return true;
    }

    private Object readResolve() {
        this.init();
        return this;
    }

    private void init() {
        this.plannedNodesCache = new HashSet<NodeProvisioner.PlannedNode>();
        this.instanceIdsToTerminate = new HashMap<String, EC2AgentTerminationReason>();
        this.plannedNodeScheduledFutures = new ArrayList();
    }

    private void removeNode(String instanceId) {
        Jenkins jenkins = Jenkins.get();
        Node n = jenkins.getNode(instanceId);
        if (n != null) {
            try {
                this.info("Fleet '%s' no longer has the instance '%s'. Removing instance from Jenkins", this.getLabelString(), instanceId);
                jenkins.removeNode(n);
            }
            catch (Exception ex) {
                throw new IllegalStateException(String.format("Error removing instance '%s' from Jenkins", instanceId), ex);
            }
        }
    }

    private void addNewAgent(Ec2Client ec2, Instance instance, FleetStateStats stats) throws Exception {
        CompletableFuture future;
        String address;
        String instanceId = instance.instanceId();
        if (this.addNodeOnlyIfRunning && InstanceStateName.RUNNING != InstanceStateName.fromValue((String)String.valueOf(instance.state().name()))) {
            return;
        }
        String string = address = this.privateIpUsed ? instance.privateIpAddress() : instance.publicIpAddress();
        if (address == null) {
            if (!this.privateIpUsed) {
                this.info("Instance '%s' public IP address not assigned. Either it could take some time or the Spot Request is not configured to assign public IPs", instance.instanceId());
            }
            return;
        }
        Object effectiveFsRoot = StringUtils.isBlank((String)this.fsRoot) ? "/tmp/jenkins-" + UUID.randomUUID().toString().substring(0, 8) : this.fsRoot;
        int effectiveNumExecutors = this.executorScaler.scale(instance.instanceType(), stats, ec2);
        EC2FleetAutoResubmitComputerLauncher computerLauncher = new EC2FleetAutoResubmitComputerLauncher(this.computerConnector.launch(address, TaskListener.NULL));
        Node.Mode nodeMode = this.restrictUsage ? Node.Mode.EXCLUSIVE : Node.Mode.NORMAL;
        EC2FleetNode node = new EC2FleetNode(instanceId, "Fleet agent for " + instanceId, (String)effectiveFsRoot, effectiveNumExecutors, nodeMode, this.labelString, new ArrayList(), this.name, (ComputerLauncher)computerLauncher, this.maxTotalUses);
        node.setRetentionStrategy(new EC2RetentionStrategy());
        Jenkins jenkins = Jenkins.get();
        jenkins.addNode((Node)node);
        if (this.plannedNodesCache.isEmpty()) {
            future = new CompletableFuture();
        } else {
            NodeProvisioner.PlannedNode plannedNode = this.plannedNodesCache.iterator().next();
            this.plannedNodesCache.remove(plannedNode);
            future = (CompletableFuture)plannedNode.future;
        }
        EC2FleetOnlineChecker.start((Node)node, future, TimeUnit.SECONDS.toMillis(this.getInitOnlineTimeoutSec()), TimeUnit.SECONDS.toMillis(this.getInitOnlineCheckIntervalSec()));
    }

    private int getCurrentSpareInstanceCount(FleetStateStats currentState, int countOfInstances) {
        boolean currentSpareInstanceCount = false;
        if (this.minSpareSize > 0) {
            Jenkins jenkins = Jenkins.get();
            int currentBusyInstances = 0;
            for (Computer computer : jenkins.getComputers()) {
                Node compNode;
                if (!(computer instanceof EC2FleetNodeComputer) || computer.isIdle() || (compNode = computer.getNode()) == null || !Objects.equals(((EC2FleetCloud)((EC2FleetNodeComputer)computer).getCloud()).getFleet(), currentState.getFleetId())) continue;
                ++currentBusyInstances;
            }
            return countOfInstances - currentBusyInstances;
        }
        return 0;
    }

    private String getLogPrefix() {
        return this.getDisplayName() + " [" + this.getLabelString() + "] ";
    }

    private void info(String msg, Object ... args) {
        LOGGER.info(this.getLogPrefix() + String.format(msg, args));
    }

    private void fine(String msg, Object ... args) {
        LOGGER.fine(this.getLogPrefix() + String.format(msg, args));
    }

    private void finer(String msg, Object ... args) {
        LOGGER.finer(this.getLogPrefix() + String.format(msg, args));
    }

    private void warning(String msg, Object ... args) {
        LOGGER.warning(this.getLogPrefix() + String.format(msg, args));
    }

    private void warning(Throwable t, String msg, Object ... args) {
        LOGGER.log(Level.WARNING, this.getLogPrefix() + String.format(msg, args), t);
    }

    public DescriptorImpl getDescriptor() {
        return (DescriptorImpl)super.getDescriptor();
    }

    public static class NoScaler
    extends ExecutorScaler {
        @DataBoundConstructor
        public NoScaler() {
        }

        @Override
        public int scale(InstanceType instanceType, FleetStateStats stats, Ec2Client ec2) {
            return this.numExecutors;
        }

        @Extension
        public static class DescriptorImpl
        extends ExecutorScaleDescriptor {
            public String getDisplayName() {
                return "No scaling";
            }
        }
    }

    public static abstract class ExecutorScaler
    extends AbstractDescribableImpl<ExecutorScaler>
    implements ExtensionPoint {
        protected int numExecutors = 1;

        protected ExecutorScaler() {
        }

        public abstract int scale(InstanceType var1, FleetStateStats var2, Ec2Client var3);

        public ExecutorScaler withNumExecutors(int numExecutors) {
            this.setNumExecutors(numExecutors);
            return this;
        }

        private void setNumExecutors(int numExecutors) {
            this.numExecutors = numExecutors;
        }

        public ExecutorScaleDescriptor getDescriptor() {
            return (ExecutorScaleDescriptor)super.getDescriptor();
        }
    }

    @Extension
    @Symbol(value={"eC2Fleet"})
    public static class DescriptorImpl
    extends Descriptor<Cloud> {
        public DescriptorImpl() {
            this.load();
        }

        public String getDisplayName() {
            return "Amazon EC2 Fleet";
        }

        public List getComputerConnectorDescriptors() {
            return Jenkins.get().getDescriptorList(ComputerConnector.class);
        }

        public List getExecutorScalerDescriptors() {
            return Jenkins.get().getDescriptorList(ExecutorScaler.class);
        }

        public ListBoxModel doFillAwsCredentialsIdItems() {
            return AWSCredentialsHelper.doFillCredentialsIdItems((ItemGroup)Jenkins.get());
        }

        public ListBoxModel doFillRegionItems(@QueryParameter String awsCredentialsId) {
            return RegionHelper.getRegionsListBoxModel(awsCredentialsId);
        }

        public FormValidation doCheckMaxTotalUses(@QueryParameter String value) {
            try {
                int val = Integer.parseInt(value);
                if (val >= -1) {
                    return FormValidation.ok();
                }
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            return FormValidation.error((String)"Maximum Total Uses must be greater or equal to -1");
        }

        public FormValidation doCheckName(@QueryParameter String name, @QueryParameter String isNewCloud) {
            try {
                Jenkins.checkGoodName((String)name);
            }
            catch (Failure e) {
                return FormValidation.error((String)e.getMessage());
            }
            if (Boolean.valueOf(isNewCloud).booleanValue() && !CloudNames.isUnique(name).booleanValue()) {
                return FormValidation.error((String)("Please choose a unique name. Existing clouds: " + Jenkins.get().clouds.stream().map(c -> c.name).collect(Collectors.joining(","))));
            }
            if (!Boolean.valueOf(isNewCloud).booleanValue() && CloudNames.isDuplicated(name).booleanValue()) {
                HashSet uniqueNames = new HashSet();
                Jenkins.get().clouds.forEach(cloud -> uniqueNames.add(cloud.name));
                return FormValidation.error((String)("This cloud name is not unique. Please choose a unique name and click save. Existing clouds: " + String.valueOf(uniqueNames)));
            }
            return FormValidation.ok();
        }

        public ListBoxModel doFillFleetItems(@QueryParameter boolean showAllFleets, @QueryParameter String region, @QueryParameter String endpoint, @QueryParameter String awsCredentialsId, @QueryParameter String fleet) {
            ListBoxModel model = new ListBoxModel();
            model.add(0, (Object)new ListBoxModel.Option("- please select -", "", true));
            try {
                for (EC2Fleet EC2Fleet2 : EC2Fleets.all()) {
                    EC2Fleet2.describe(awsCredentialsId, region, endpoint, model, fleet, showAllFleets);
                }
            }
            catch (Exception ex) {
                LOGGER.log(Level.WARNING, String.format("Cannot describe fleets in '%s' or by endpoint '%s'", region, endpoint), ex);
                return model;
            }
            return model;
        }

        public String getDefaultCloudName() {
            return CloudNames.generateUnique(EC2FleetCloud.BASE_DEFAULT_FLEET_CLOUD_ID);
        }

        public Boolean isExistingCloudNameDuplicated(@QueryParameter String name) {
            return CloudNames.isDuplicated(name);
        }

        public FormValidation doCheckFleet(@QueryParameter String fleet) {
            if (StringUtils.isEmpty((String)fleet)) {
                return FormValidation.error((String)"Please select a valid EC2 Fleet");
            }
            return FormValidation.ok();
        }

        public FormValidation doTestConnection(@QueryParameter String awsCredentialsId, @QueryParameter String region, @QueryParameter String endpoint, @QueryParameter String fleet) {
            AwsPermissionChecker awsPermissionChecker = new AwsPermissionChecker(awsCredentialsId, region, endpoint);
            List<String> missingPermissions = awsPermissionChecker.getMissingPermissions(fleet);
            String disclaimer = String.format("Skipping validation for following permissions: %s, %s, %s", new Object[]{AwsPermissionChecker.FleetAPI.TerminateInstances, AwsPermissionChecker.FleetAPI.UpdateAutoScalingGroup, AwsPermissionChecker.FleetAPI.ModifySpotFleetRequest});
            if (missingPermissions.isEmpty()) {
                return FormValidation.ok((String)String.format("Success! %s", disclaimer));
            }
            String errorMessage = String.format("Following AWS permissions are missing: %s ", String.join((CharSequence)", ", missingPermissions));
            LOGGER.log(Level.WARNING, String.format("[TestConnection] %s", errorMessage));
            return FormValidation.error((String)String.format("%s %n %s", errorMessage, disclaimer));
        }

        public boolean configure(StaplerRequest2 req, JSONObject formData) throws Descriptor.FormException {
            req.bindJSON((Object)this, formData);
            this.save();
            return super.configure(req, formData);
        }
    }

    public static class NodeHardwareScaler
    extends ExecutorScaler {
        private int vCpuPerExecutor;
        private int memoryGiBPerExecutor;

        @DataBoundConstructor
        public NodeHardwareScaler(int vCpuPerExecutor, int memoryGiBPerExecutor) {
            this.vCpuPerExecutor = vCpuPerExecutor;
            this.memoryGiBPerExecutor = memoryGiBPerExecutor;
        }

        @DataBoundSetter
        public void setvCpuPerExecutor(int value) {
            this.vCpuPerExecutor = value;
        }

        @DataBoundSetter
        public void setMemoryGiBPerExecutor(int value) {
            this.memoryGiBPerExecutor = value;
        }

        public int getvCpuPerExecutor() {
            return this.vCpuPerExecutor;
        }

        public int getMemoryGiBPerExecutor() {
            return this.memoryGiBPerExecutor;
        }

        @Override
        public int scale(InstanceType instanceType, FleetStateStats stats, Ec2Client ec2) {
            if (this.vCpuPerExecutor == 0 && this.memoryGiBPerExecutor == 0) {
                return this.numExecutors;
            }
            int vCPUNumExecutors = Integer.MAX_VALUE;
            int memoryNumExecutors = Integer.MAX_VALUE;
            InstanceTypeInfo instanceTypeInfo = this.getInstanceTypeInfo(ec2, instanceType);
            if (this.vCpuPerExecutor != 0) {
                int instanceVCPUs = instanceTypeInfo.vCpuInfo().defaultVCpus();
                vCPUNumExecutors = Math.max(instanceVCPUs / this.vCpuPerExecutor, 1);
            }
            if (this.memoryGiBPerExecutor != 0) {
                long instanceMemory = instanceTypeInfo.memoryInfo().sizeInMiB() / 1024L;
                memoryNumExecutors = Math.max(Math.round((float)instanceMemory / (float)this.memoryGiBPerExecutor), 1);
            }
            return Math.min(vCPUNumExecutors, memoryNumExecutors);
        }

        private InstanceTypeInfo getInstanceTypeInfo(Ec2Client ec2, InstanceType instanceType) {
            DescribeInstanceTypesRequest request = (DescribeInstanceTypesRequest)DescribeInstanceTypesRequest.builder().instanceTypes(new InstanceType[]{instanceType}).build();
            DescribeInstanceTypesResponse result = ec2.describeInstanceTypes(request);
            return (InstanceTypeInfo)result.instanceTypes().get(0);
        }

        @Extension
        public static class DescriptorImpl
        extends ExecutorScaleDescriptor {
            public String getDisplayName() {
                return "Scale by node hardware";
            }
        }
    }

    public static class WeightedScaler
    extends ExecutorScaler {
        @DataBoundConstructor
        public WeightedScaler() {
        }

        @Override
        public int scale(InstanceType instanceType, FleetStateStats stats, Ec2Client ec2) {
            if (stats == null) {
                return this.numExecutors;
            }
            Double instanceTypeWeight = stats.getInstanceTypeWeights().get(instanceType.toString());
            if (instanceTypeWeight == null) {
                return this.numExecutors;
            }
            return (int)Math.max(Math.round((double)this.numExecutors * instanceTypeWeight), 1L);
        }

        @Extension
        public static class DescriptorImpl
        extends ExecutorScaleDescriptor {
            public String getDisplayName() {
                return "Scale by weight";
            }
        }
    }

    public static class ExecutorScaleDescriptor
    extends Descriptor<ExecutorScaler> {
    }
}

