/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.jenkins.ec2fleet;

import com.amazon.jenkins.ec2fleet.AbstractEC2FleetCloud;
import com.amazon.jenkins.ec2fleet.CloudNames;
import com.amazon.jenkins.ec2fleet.EC2AgentTerminationReason;
import com.amazon.jenkins.ec2fleet.EC2FleetAutoResubmitComputerLauncher;
import com.amazon.jenkins.ec2fleet.EC2FleetLabelParameters;
import com.amazon.jenkins.ec2fleet.EC2FleetNode;
import com.amazon.jenkins.ec2fleet.EC2FleetOnlineChecker;
import com.amazon.jenkins.ec2fleet.EC2RetentionStrategy;
import com.amazon.jenkins.ec2fleet.FleetStateStats;
import com.amazon.jenkins.ec2fleet.JenkinsUtils;
import com.amazon.jenkins.ec2fleet.Registry;
import com.amazon.jenkins.ec2fleet.aws.AwsPermissionChecker;
import com.amazon.jenkins.ec2fleet.aws.CloudFormationApi;
import com.amazon.jenkins.ec2fleet.aws.EC2Api;
import com.amazon.jenkins.ec2fleet.aws.RegionHelper;
import com.amazon.jenkins.ec2fleet.fleet.EC2Fleets;
import com.amazon.jenkins.ec2fleet.fleet.EC2SpotFleet;
import com.cloudbees.jenkins.plugins.awscredentials.AWSCredentialsHelper;
import hudson.Extension;
import hudson.model.AbstractProject;
import hudson.model.Descriptor;
import hudson.model.Failure;
import hudson.model.Item;
import hudson.model.ItemGroup;
import hudson.model.Label;
import hudson.model.Node;
import hudson.model.Queue;
import hudson.model.TaskListener;
import hudson.slaves.Cloud;
import hudson.slaves.ComputerConnector;
import hudson.slaves.ComputerLauncher;
import hudson.slaves.NodeProvisioner;
import hudson.util.FormValidation;
import hudson.util.ListBoxModel;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.logging.SimpleFormatter;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import jenkins.model.Jenkins;
import net.sf.json.JSONObject;
import org.apache.commons.lang.StringUtils;
import org.jenkinsci.Symbol;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.QueryParameter;
import org.kohsuke.stapler.StaplerRequest2;
import software.amazon.awssdk.services.cloudformation.CloudFormationClient;
import software.amazon.awssdk.services.cloudformation.model.StackStatus;
import software.amazon.awssdk.services.ec2.Ec2Client;
import software.amazon.awssdk.services.ec2.model.Instance;
import software.amazon.awssdk.services.ec2.model.InstanceStateName;
import software.amazon.awssdk.services.ec2.model.KeyPairInfo;

public class EC2FleetLabelCloud
extends AbstractEC2FleetCloud {
    public static final String EC2_INSTANCE_TAG_NAMESPACE = "ec2-fleet-plugin";
    public static final String EC2_INSTANCE_CLOUD_NAME_TAG = "ec2-fleet-plugin:cloud-name";
    public static final String BASE_DEFAULT_FLEET_CLOUD_ID = "FleetCloudLabel";
    public static final int DEFAULT_CLOUD_STATUS_INTERVAL_SEC = 10;
    private static final int DEFAULT_INIT_ONLINE_TIMEOUT_SEC = 180;
    private static final int DEFAULT_INIT_ONLINE_CHECK_INTERVAL_SEC = 15;
    private static final SimpleFormatter sf = new SimpleFormatter();
    private static final Logger LOGGER = Logger.getLogger(EC2FleetLabelCloud.class.getName());
    private final String awsCredentialsId;
    private final String region;
    private final String endpoint;
    private final String fsRoot;
    private final ComputerConnector computerConnector;
    private final boolean privateIpUsed;
    private final boolean alwaysReconnect;
    private final Integer idleMinutes;
    private final Integer minSize;
    private final Integer maxSize;
    private final Integer numExecutors;
    private final boolean restrictUsage;
    private final Integer initOnlineTimeoutSec;
    private final Integer initOnlineCheckIntervalSec;
    private final Integer cloudStatusIntervalSec;
    private final String ec2KeyPairName;
    private final boolean disableTaskResubmit;
    private final boolean noDelayProvision;
    private transient Map<String, State> states;

    @DataBoundConstructor
    public EC2FleetLabelCloud(String name, String awsCredentialsId, String region, String endpoint, String fsRoot, ComputerConnector computerConnector, boolean privateIpUsed, boolean alwaysReconnect, Integer idleMinutes, int minSize, int maxSize, int numExecutors, boolean restrictUsage, boolean disableTaskResubmit, Integer initOnlineTimeoutSec, Integer initOnlineCheckIntervalSec, Integer cloudStatusIntervalSec, boolean noDelayProvision, String ec2KeyPairName) {
        super(StringUtils.isNotBlank((String)name) ? name : CloudNames.generateUnique(BASE_DEFAULT_FLEET_CLOUD_ID));
        this.init();
        this.awsCredentialsId = awsCredentialsId;
        this.region = region;
        this.endpoint = endpoint;
        this.fsRoot = fsRoot;
        this.computerConnector = computerConnector;
        this.idleMinutes = idleMinutes;
        this.privateIpUsed = privateIpUsed;
        this.alwaysReconnect = alwaysReconnect;
        if (minSize < 0) {
            this.warning("Cloud parameter 'minSize' can't be less than 0, setting to 0", new Object[0]);
        }
        this.minSize = Math.max(0, minSize);
        this.maxSize = maxSize;
        this.numExecutors = Math.max(numExecutors, 1);
        this.restrictUsage = restrictUsage;
        this.disableTaskResubmit = disableTaskResubmit;
        this.initOnlineTimeoutSec = initOnlineTimeoutSec;
        this.initOnlineCheckIntervalSec = initOnlineCheckIntervalSec;
        this.cloudStatusIntervalSec = cloudStatusIntervalSec;
        this.noDelayProvision = noDelayProvision;
        this.ec2KeyPairName = ec2KeyPairName;
    }

    public String getEc2KeyPairName() {
        return this.ec2KeyPairName;
    }

    public boolean isNoDelayProvision() {
        return this.noDelayProvision;
    }

    public String getAwsCredentialsId() {
        return this.awsCredentialsId;
    }

    @Override
    public boolean isDisableTaskResubmit() {
        return this.disableTaskResubmit;
    }

    public int getInitOnlineTimeoutSec() {
        return this.initOnlineTimeoutSec == null ? 180 : this.initOnlineTimeoutSec;
    }

    public int getCloudStatusIntervalSec() {
        return this.cloudStatusIntervalSec == null ? 10 : this.cloudStatusIntervalSec;
    }

    public int getInitOnlineCheckIntervalSec() {
        return this.initOnlineCheckIntervalSec == null ? 15 : this.initOnlineCheckIntervalSec;
    }

    public String getRegion() {
        return this.region;
    }

    public String getEndpoint() {
        return this.endpoint;
    }

    public String getFsRoot() {
        return this.fsRoot;
    }

    public ComputerConnector getComputerConnector() {
        return this.computerConnector;
    }

    public boolean isPrivateIpUsed() {
        return this.privateIpUsed;
    }

    @Override
    public boolean isAlwaysReconnect() {
        return this.alwaysReconnect;
    }

    @Override
    public int getIdleMinutes() {
        return this.idleMinutes != null ? this.idleMinutes : 0;
    }

    public int getMaxSize() {
        return this.maxSize;
    }

    public int getMinSize() {
        return this.minSize;
    }

    public int getNumExecutors() {
        return this.numExecutors;
    }

    public String getJvmSettings() {
        return "";
    }

    public boolean isRestrictUsage() {
        return this.restrictUsage;
    }

    @Override
    public synchronized boolean hasExcessCapacity() {
        return Boolean.FALSE;
    }

    public synchronized Collection<NodeProvisioner.PlannedNode> provision(@Nonnull Cloud.CloudState cloudState, int excessWorkload) {
        Jenkins jenkinsInstance = Jenkins.get();
        if (jenkinsInstance.isQuietingDown()) {
            LOGGER.log(Level.FINE, "Not provisioning nodes, Jenkins instance is quieting down");
            return Collections.emptyList();
        }
        if (jenkinsInstance.isTerminating()) {
            LOGGER.log(Level.FINE, "Not provisioning nodes, Jenkins instance is terminating");
            return Collections.emptyList();
        }
        this.info("excessWorkload %s", excessWorkload);
        Label label = cloudState.getLabel();
        ArrayList<NodeProvisioner.PlannedNode> r = new ArrayList<NodeProvisioner.PlannedNode>();
        for (Map.Entry<String, State> state : this.states.entrySet()) {
            if (!Label.parse((String)state.getKey()).containsAll(label.listAtoms())) continue;
            LOGGER.info("provision " + String.valueOf(label) + " excessWorkload " + excessWorkload);
            FleetStateStats stats = state.getValue().stats;
            int cap = stats.getNumDesired() + state.getValue().toAdd;
            if (!stats.getState().isActive()) {
                this.info("fleet in %s not active state", stats.getState().getDetailed());
                continue;
            }
            EC2FleetLabelParameters parameters = new EC2FleetLabelParameters(state.getKey());
            int maxSize = parameters.getIntOrDefault("maxSize", this.maxSize);
            if (cap >= maxSize) {
                this.info("max %s reached, no more provision", maxSize);
                continue;
            }
            int numExecutors1 = Math.max(parameters.getIntOrDefault("numExecutors", this.numExecutors), 1);
            int weightedExcessWorkload = (excessWorkload + numExecutors1 - 1) / numExecutors1;
            int targetCapacity = Math.min(cap + weightedExcessWorkload, maxSize);
            int toProvision = targetCapacity - cap;
            this.info("to provision = %s", toProvision);
            if (toProvision < 1) {
                return Collections.emptyList();
            }
            state.getValue().toAdd += toProvision;
            for (int f = 0; f < toProvision; ++f) {
                NodeProvisioner.PlannedNode plannedNode = new NodeProvisioner.PlannedNode("FleetNode-" + r.size(), new CompletableFuture(), this.numExecutors.intValue());
                r.add(plannedNode);
                state.getValue().plannedNodes.add(plannedNode);
            }
        }
        return r;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void update() {
        HashMap<String, State> currentStates;
        this.info("start", new Object[0]);
        EC2FleetLabelCloud eC2FleetLabelCloud = this;
        synchronized (eC2FleetLabelCloud) {
            currentStates = new HashMap<String, State>();
            for (Map.Entry<String, State> object : this.states.entrySet()) {
                currentStates.put(object.getKey(), new State(object.getValue()));
            }
        }
        HashSet<String> fleetIds = new HashSet<String>();
        for (State state : this.states.values()) {
            fleetIds.add(state.fleetId);
        }
        Map<String, FleetStateStats> currentStats = new EC2SpotFleet().getStateBatch(this.getAwsCredentialsId(), this.region, this.endpoint, fleetIds);
        for (State state : currentStates.values()) {
            state.stats = currentStats.get(state.fleetId);
            state.targetCapacity = Math.max(0, state.stats.getNumDesired() - state.instanceIdsToTerminate.size() + state.toAdd);
            state.stats = new FleetStateStats(state.stats, state.targetCapacity);
        }
        this.updateByState(currentStates);
        EC2FleetLabelCloud eC2FleetLabelCloud2 = this;
        synchronized (eC2FleetLabelCloud2) {
            for (Map.Entry entry : currentStates.entrySet()) {
                State state = this.states.get(entry.getKey());
                state.stats = ((State)entry.getValue()).stats;
                state.instanceIdsToTerminate.keySet().removeAll(((State)entry.getValue()).instanceIdsToTerminate.keySet());
                state.toAdd -= ((State)entry.getValue()).toAdd;
                state.plannedNodes.removeAll(((State)entry.getValue()).plannedNodesToRemove);
                while (state.plannedNodes.size() > ((State)entry.getValue()).targetCapacity) {
                    Iterator<NodeProvisioner.PlannedNode> iterator = state.plannedNodes.iterator();
                    NodeProvisioner.PlannedNode plannedNodeToCancel = iterator.next();
                    iterator.remove();
                    plannedNodeToCancel.future.cancel(true);
                }
            }
        }
    }

    private void updateByState(Map<String, State> states) {
        final Jenkins jenkins = Jenkins.get();
        final Ec2Client ec2 = Registry.getEc2Api().connect(this.getAwsCredentialsId(), this.region, this.endpoint);
        for (State state : states.values()) {
            if (state.toAdd <= 0 && state.instanceIdsToTerminate.size() <= 0) continue;
            EC2Fleets.get(state.fleetId).modify(this.getAwsCredentialsId(), this.region, this.endpoint, state.fleetId, state.targetCapacity, this.minSize, this.maxSize);
            this.info("Update fleet target capacity to %s", state.targetCapacity);
        }
        final HashMap<String, EC2AgentTerminationReason> instanceIdsToRemove = new HashMap<String, EC2AgentTerminationReason>();
        for (State state : states.values()) {
            instanceIdsToRemove.putAll(state.instanceIdsToTerminate);
        }
        if (instanceIdsToRemove.size() > 0) {
            Queue.withLock((Runnable)new Runnable(){
                final /* synthetic */ EC2FleetLabelCloud this$0;
                {
                    this.this$0 = this$0;
                }

                @Override
                public void run() {
                    this.this$0.info("Removing Jenkins nodes before terminating corresponding EC2 instances", new Object[0]);
                    for (String instanceId : instanceIdsToRemove.keySet()) {
                        Node node = jenkins.getNode(instanceId);
                        if (node == null) continue;
                        try {
                            jenkins.removeNode(node);
                        }
                        catch (IOException e) {
                            this.this$0.warning("unable to remove node %s from Jenkins, skip, just terminate EC2 instance", instanceId);
                        }
                    }
                }
            });
            this.info("Delete terminating nodes from Jenkins %s", instanceIdsToRemove);
            Registry.getEc2Api().terminateInstances(ec2, instanceIdsToRemove.keySet());
            this.info("Instances %s were terminated with result", instanceIdsToRemove);
        }
        for (final Map.Entry entry : states.entrySet()) {
            final State state = (State)entry.getValue();
            this.info("fleet instances %s", state.stats.getInstances());
            HashSet<String> fleetInstances = new HashSet<String>(state.stats.getInstances());
            Map<String, Instance> described = Registry.getEc2Api().describeInstances(ec2, fleetInstances);
            this.info("described instances %s", described.keySet());
            HashSet<String> jenkinsInstances = new HashSet<String>();
            for (Node node : jenkins.getNodes()) {
                EC2FleetNode node1;
                if (!(node instanceof EC2FleetNode) || (node1 = (EC2FleetNode)node).getCloud() != this || !node1.getLabelString().equals(entry.getKey())) continue;
                jenkinsInstances.add(node.getNodeName());
            }
            this.info("jenkins nodes %s", jenkinsInstances);
            HashSet jenkinsNodesWithInstance = new HashSet(jenkinsInstances);
            jenkinsNodesWithInstance.removeAll(fleetInstances);
            this.info("jenkins nodes without instance %s", jenkinsNodesWithInstance);
            HashSet<String> terminatedFleetInstances = new HashSet<String>(fleetInstances);
            terminatedFleetInstances.removeAll(described.keySet());
            this.info("terminated instances " + String.valueOf(terminatedFleetInstances), new Object[0]);
            final HashMap<String, Instance> newFleetInstances = new HashMap<String, Instance>(described);
            for (String string : jenkinsInstances) {
                newFleetInstances.remove(string);
            }
            this.info("new instances " + String.valueOf(newFleetInstances.keySet()), new Object[0]);
            ArrayList<String> jenkinsNodesToRemove = new ArrayList<String>();
            jenkinsNodesToRemove.addAll(terminatedFleetInstances);
            jenkinsNodesToRemove.addAll(jenkinsNodesWithInstance);
            for (String instance : jenkinsNodesToRemove) {
                JenkinsUtils.removeNode(instance);
            }
            if (newFleetInstances.size() <= 0) continue;
            try {
                Registry.getEc2Api().tagInstances(ec2, newFleetInstances.keySet(), EC2_INSTANCE_CLOUD_NAME_TAG, this.name);
            }
            catch (Exception exception) {
                this.warning(exception, "failed to tag new instances %s, skip", newFleetInstances.keySet());
            }
            Queue.withLock((Runnable)new Runnable(){
                final /* synthetic */ EC2FleetLabelCloud this$0;
                {
                    this.this$0 = this$0;
                }

                @Override
                public void run() {
                    try {
                        for (Instance instance : newFleetInstances.values()) {
                            this.this$0.addNewAgent(ec2, instance, (String)entry.getKey(), state);
                        }
                    }
                    catch (Exception ex) {
                        this.this$0.warning(ex, "Unable to set label on node", new Object[0]);
                    }
                }
            });
        }
    }

    @Override
    public synchronized boolean scheduleToTerminate(String instanceId, boolean ignoreMinConstraints, EC2AgentTerminationReason terminationReason) {
        this.info("Attempting to terminate instance: %s", instanceId);
        Node node = Jenkins.get().getNode(instanceId);
        if (node == null) {
            return false;
        }
        State state = this.states.get(node.getLabelString());
        if (state == null) {
            this.info("Skip termination, unknown label " + node.getLabelString() + " for node " + instanceId, new Object[0]);
            return false;
        }
        EC2FleetLabelParameters parameters = new EC2FleetLabelParameters(node.getLabelString());
        int minSize = parameters.getIntOrDefault("minSize", this.minSize);
        if (!ignoreMinConstraints && minSize > 0 && state.stats.getNumDesired() - state.instanceIdsToTerminate.size() <= minSize) {
            this.info("Not terminating %s because we need a minimum of %s instances running.", instanceId, minSize);
            return false;
        }
        this.info("Scheduling instance '%s' for termination on cloud %s because of reason: %s", new Object[]{instanceId, this, terminationReason});
        state.instanceIdsToTerminate.put(instanceId, terminationReason);
        return true;
    }

    public synchronized boolean canProvision(Cloud.CloudState cloudState) {
        Label label = cloudState.getLabel();
        for (String labelString : this.states.keySet()) {
            boolean r = label == null || Label.parse((String)labelString).containsAll(label.listAtoms());
            this.fine("CanProvision called on fleet: \"" + labelString + "\" wanting: \"" + (label == null ? "(unspecified)" : label.getName()) + "\". Returning " + r + ".", new Object[0]);
            if (!r) continue;
            return true;
        }
        return false;
    }

    private Object readResolve() {
        this.init();
        return this;
    }

    private void init() {
        this.states = new HashMap<String, State>();
    }

    private void addNewAgent(Ec2Client ec2, Instance instance, String labelString, State state) throws Exception {
        CompletableFuture future;
        String address;
        String instanceId = instance.instanceId();
        if (InstanceStateName.RUNNING != instance.state().name()) {
            return;
        }
        String string = address = this.privateIpUsed ? instance.privateIpAddress() : instance.publicIpAddress();
        if (address == null) {
            if (!this.privateIpUsed) {
                this.info("%s instance public IP address not assigned, it could take some time or Spot Request is not configured to assign public IPs", instance.instanceId());
            }
            return;
        }
        Object effectiveFsRoot = StringUtils.isBlank((String)this.fsRoot) ? "/tmp/jenkins-" + UUID.randomUUID().toString().substring(0, 8) : this.fsRoot;
        Double instanceTypeWeight = state.stats.getInstanceTypeWeights().get(String.valueOf(instance.instanceType()));
        int effectiveNumExecutors = instanceTypeWeight != null ? (int)Math.max(Math.round((double)this.numExecutors.intValue() * instanceTypeWeight), 1L) : this.numExecutors;
        EC2FleetAutoResubmitComputerLauncher computerLauncher = new EC2FleetAutoResubmitComputerLauncher(this.computerConnector.launch(address, TaskListener.NULL));
        Node.Mode nodeMode = this.restrictUsage ? Node.Mode.EXCLUSIVE : Node.Mode.NORMAL;
        EC2FleetNode node = new EC2FleetNode(instanceId, "Fleet agent for " + instanceId, (String)effectiveFsRoot, effectiveNumExecutors, nodeMode, labelString, new ArrayList(), this.name, (ComputerLauncher)computerLauncher, -1);
        node.setRetentionStrategy(new EC2RetentionStrategy());
        Jenkins jenkins = Jenkins.get();
        jenkins.addNode((Node)node);
        if (state.plannedNodes.isEmpty()) {
            future = new CompletableFuture();
        } else {
            Iterator<NodeProvisioner.PlannedNode> iterator = state.plannedNodes.iterator();
            NodeProvisioner.PlannedNode plannedNode = iterator.next();
            iterator.remove();
            state.plannedNodesToRemove.add(plannedNode);
            future = (CompletableFuture)plannedNode.future;
        }
        EC2FleetOnlineChecker.start((Node)node, future, TimeUnit.SECONDS.toMillis(this.getInitOnlineTimeoutSec()), TimeUnit.SECONDS.toMillis(this.getInitOnlineCheckIntervalSec()));
    }

    private String getLogPrefix() {
        return this.getDisplayName() + " ";
    }

    private void info(String msg, Object ... args) {
        LOGGER.info(this.getLogPrefix() + String.format(msg, args));
    }

    private void fine(String msg, Object ... args) {
        LOGGER.fine(this.getLogPrefix() + String.format(msg, args));
    }

    private void warning(String msg, Object ... args) {
        LOGGER.warning(this.getLogPrefix() + String.format(msg, args));
    }

    private void warning(Throwable t, String msg, Object ... args) {
        LOGGER.log(Level.WARNING, this.getLogPrefix() + String.format(msg, args), t);
    }

    private static <T> Set<T> missed(Set<T> what, Set<T> where) {
        HashSet<T> m = new HashSet<T>();
        for (T item : what) {
            if (where.contains(item)) continue;
            m.add(item);
        }
        return m;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateStacks() {
        final Jenkins jenkins = Jenkins.get();
        CloudFormationApi cloudFormationApi = Registry.getCloudFormationApi();
        CloudFormationClient client = cloudFormationApi.connect(this.awsCredentialsId, this.region, this.endpoint);
        Map<String, CloudFormationApi.StackInfo> allStacks = cloudFormationApi.describe(client, this.name);
        HashSet<String> labels = new HashSet<String>();
        for (Item item : Jenkins.get().getAllItems()) {
            AbstractProject abstractProject;
            String labelString;
            if (!(item instanceof AbstractProject) || !(labelString = StringUtils.defaultString((String)(abstractProject = (AbstractProject)item).getAssignedLabelString())).startsWith(this.name)) continue;
            labels.add(labelString);
        }
        Set<String> labelsWithoutStacks = EC2FleetLabelCloud.missed(labels, allStacks.keySet());
        Set<String> stacksWithoutLabels = EC2FleetLabelCloud.missed(allStacks.keySet(), labels);
        HashSet<String> runningStacksWithLabels = new HashSet<String>();
        for (Map.Entry<String, CloudFormationApi.StackInfo> entry : allStacks.entrySet()) {
            if (!labels.contains(entry.getKey()) || entry.getValue().stackStatus != StackStatus.CREATE_COMPLETE) continue;
            runningStacksWithLabels.add(entry.getKey());
        }
        LOGGER.info("running stacks " + String.valueOf(runningStacksWithLabels));
        for (String string : labelsWithoutStacks) {
            LOGGER.info("creating stack for label " + string);
            cloudFormationApi.create(client, this.name, this.ec2KeyPairName, string);
        }
        for (final String string : stacksWithoutLabels) {
            CloudFormationApi.StackInfo stack = allStacks.get(string);
            if (stack.stackStatus == StackStatus.CREATE_COMPLETE) {
                LOGGER.info("deleting unused stack " + stack.stackId + " for label " + string);
                cloudFormationApi.delete(client, stack.stackId);
                final ArrayList instanceIdsToRemove = new ArrayList();
                Queue.withLock((Runnable)new Runnable(){
                    final /* synthetic */ EC2FleetLabelCloud this$0;
                    {
                        this.this$0 = this$0;
                    }

                    @Override
                    public void run() {
                        for (Node node : jenkins.getNodes()) {
                            if (!string.equals(node.getLabelString())) continue;
                            String instanceId = node.getNodeName();
                            instanceIdsToRemove.add(instanceId);
                            try {
                                jenkins.removeNode(node);
                            }
                            catch (IOException e) {
                                this.this$0.warning("unable delete node %s from Jenkins, skip, actual instance will be terminated by stack", instanceId);
                            }
                        }
                    }
                });
                this.info("Delete nodes from deleted stack from Jenkins %s", instanceIdsToRemove);
                continue;
            }
            LOGGER.info("unused stack " + stack.stackId + " for label " + string + " is status " + String.valueOf(stack.stackStatus) + ", skip to delete");
        }
        Object object = this;
        synchronized (object) {
            for (String label : runningStacksWithLabels) {
                if (this.states.containsKey(label)) continue;
                CloudFormationApi.StackInfo stack = allStacks.get(label);
                this.states.put(label, new State(stack.fleetId));
            }
            Iterator<Map.Entry<String, State>> iterator = this.states.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry<String, State> state = iterator.next();
                if (runningStacksWithLabels.contains(state.getKey())) continue;
                iterator.remove();
            }
        }
    }

    public DescriptorImpl getDescriptor() {
        return (DescriptorImpl)super.getDescriptor();
    }

    private static class State {
        final String fleetId;
        FleetStateStats stats;
        int targetCapacity;
        int toAdd;
        final Set<NodeProvisioner.PlannedNode> plannedNodes;
        final Set<NodeProvisioner.PlannedNode> plannedNodesToRemove;
        final Map<String, EC2AgentTerminationReason> instanceIdsToTerminate;

        public State(String fleetId) {
            this.fleetId = fleetId;
            this.plannedNodes = new HashSet<NodeProvisioner.PlannedNode>();
            this.plannedNodesToRemove = new HashSet<NodeProvisioner.PlannedNode>();
            this.instanceIdsToTerminate = new HashMap<String, EC2AgentTerminationReason>();
        }

        public State(State state) {
            this.plannedNodes = new HashSet<NodeProvisioner.PlannedNode>(state.plannedNodes);
            this.fleetId = state.fleetId;
            this.stats = state.stats;
            this.targetCapacity = state.targetCapacity;
            this.toAdd = state.toAdd;
            this.plannedNodesToRemove = new HashSet<NodeProvisioner.PlannedNode>(state.plannedNodesToRemove);
            this.instanceIdsToTerminate = new HashMap<String, EC2AgentTerminationReason>(state.instanceIdsToTerminate);
        }
    }

    @Extension
    @Symbol(value={"eC2FleetLabel"})
    public static class DescriptorImpl
    extends Descriptor<Cloud> {
        public DescriptorImpl() {
            this.load();
        }

        public String getDisplayName() {
            return "Amazon EC2 Fleet label based";
        }

        public List getComputerConnectorDescriptors() {
            return Jenkins.get().getDescriptorList(ComputerConnector.class);
        }

        public ListBoxModel doFillAwsCredentialsIdItems() {
            return AWSCredentialsHelper.doFillCredentialsIdItems((ItemGroup)Jenkins.get());
        }

        public ListBoxModel doFillRegionItems(@QueryParameter String awsCredentialsId) {
            return RegionHelper.getRegionsListBoxModel(awsCredentialsId);
        }

        public ListBoxModel doFillEc2KeyPairNameItems(@QueryParameter String awsCredentialsId, @QueryParameter String region, @QueryParameter String endpoint) {
            ListBoxModel model = new ListBoxModel();
            try {
                Ec2Client amazonEC2 = new EC2Api().connect(awsCredentialsId, region, endpoint);
                List keyPairs = amazonEC2.describeKeyPairs().keyPairs();
                for (KeyPairInfo keyPair : keyPairs) {
                    model.add((Object)new ListBoxModel.Option(keyPair.keyName(), keyPair.keyName()));
                }
            }
            catch (Exception e) {
                LOGGER.log(Level.WARNING, String.format("Cannot describe key pairs credentials %s region %s endpoint %s", awsCredentialsId, region, endpoint), e);
            }
            return model;
        }

        public FormValidation doTestConnection(@QueryParameter String awsCredentialsId, @QueryParameter String region, @QueryParameter String endpoint, @QueryParameter String fleet) {
            AwsPermissionChecker awsPermissionChecker = new AwsPermissionChecker(awsCredentialsId, region, endpoint);
            List<String> missingPermissions = awsPermissionChecker.getMissingPermissions(fleet);
            String disclaimer = String.format("Skipping validation for following permissions: %s, %s", new Object[]{AwsPermissionChecker.FleetAPI.TerminateInstances, AwsPermissionChecker.FleetAPI.UpdateAutoScalingGroup});
            if (missingPermissions.isEmpty()) {
                return FormValidation.ok((String)String.format("Success! %s", disclaimer));
            }
            String errorMessage = String.format("Following AWS permissions are missing: %s ", String.join((CharSequence)", ", missingPermissions));
            LOGGER.log(Level.WARNING, String.format("[TestConnection] %s", errorMessage));
            return FormValidation.error((String)String.format("%s %n %s", errorMessage, disclaimer));
        }

        public FormValidation doCheckName(@QueryParameter String name, @QueryParameter String isNewCloud) {
            try {
                Jenkins.checkGoodName((String)name);
            }
            catch (Failure e) {
                return FormValidation.error((String)e.getMessage());
            }
            if (Boolean.valueOf(isNewCloud).booleanValue() && !CloudNames.isUnique(name).booleanValue()) {
                return FormValidation.error((String)("Please choose a unique name. Existing clouds: " + Jenkins.get().clouds.stream().map(c -> c.name).collect(Collectors.joining(","))));
            }
            if (!Boolean.valueOf(isNewCloud).booleanValue() && CloudNames.isDuplicated(name).booleanValue()) {
                HashSet uniqueNames = new HashSet();
                Jenkins.get().clouds.forEach(cloud -> uniqueNames.add(cloud.name));
                return FormValidation.error((String)("This cloud name is not unique. Please choose a unique name and click save. Existing clouds: " + String.valueOf(uniqueNames)));
            }
            return FormValidation.ok();
        }

        public String getDefaultCloudName() {
            return CloudNames.generateUnique(EC2FleetLabelCloud.BASE_DEFAULT_FLEET_CLOUD_ID);
        }

        public Boolean isExistingCloudNameDuplicated(@QueryParameter String name) {
            return CloudNames.isDuplicated(name);
        }

        public boolean configure(StaplerRequest2 req, JSONObject formData) throws Descriptor.FormException {
            req.bindJSON((Object)this, formData);
            this.save();
            return super.configure(req, formData);
        }
    }
}

