/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.jenkins.ec2fleet.aws;

import com.amazon.jenkins.ec2fleet.Registry;
import com.amazon.jenkins.ec2fleet.aws.RegionInfo;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import hudson.util.ListBoxModel;
import java.util.TreeMap;
import java.util.stream.Collectors;
import software.amazon.awssdk.services.ec2.Ec2Client;
import software.amazon.awssdk.services.ec2.model.DescribeRegionsResponse;
import software.amazon.awssdk.services.ec2.model.Region;

public class RegionHelper {
    @SuppressFBWarnings(value={"DE_MIGHT_IGNORE", "WMI_WRONG_MAP_ITERATOR"}, justification="Ignore API exceptions and key iterator is really intended")
    public static ListBoxModel getRegionsListBoxModel(String awsCredentialsId) {
        TreeMap<String, String> regionDisplayNames = new TreeMap<String, String>();
        try {
            Ec2Client client = Registry.getEc2Api().connect(awsCredentialsId, null, null);
            DescribeRegionsResponse regions = client.describeRegions();
            regionDisplayNames.putAll(regions.regions().stream().collect(Collectors.toMap(Region::regionName, Region::regionName)));
        }
        catch (Exception client) {
            // empty catch block
        }
        regionDisplayNames.putAll(software.amazon.awssdk.regions.Region.regions().stream().collect(Collectors.toMap(software.amazon.awssdk.regions.Region::id, software.amazon.awssdk.regions.Region::id)));
        regionDisplayNames.putAll(RegionInfo.getRegionNames().stream().collect(Collectors.toMap(r -> r, r -> r)));
        ListBoxModel model = new ListBoxModel();
        for (String regionName : regionDisplayNames.keySet()) {
            try {
                software.amazon.awssdk.regions.Region sdkRegion;
                RegionInfo region = RegionInfo.fromName(regionName);
                String regionDescription = region != null ? region.getDescription() : ((sdkRegion = software.amazon.awssdk.regions.Region.of((String)regionName)) != null && sdkRegion.metadata() != null && sdkRegion.metadata().description() != null ? sdkRegion.metadata().description() : null);
                String regionDisplayName = regionDescription != null ? String.format("%s %s", regionName, regionDescription) : regionName;
                regionDisplayNames.put(regionName, regionDisplayName);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
            model.add((Object)new ListBoxModel.Option((String)regionDisplayNames.get(regionName), regionName));
        }
        return model;
    }
}

