/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.jenkins.ec2fleet.fleet;

import com.amazon.jenkins.ec2fleet.FleetStateStats;
import com.amazon.jenkins.ec2fleet.aws.AWSUtils;
import com.amazon.jenkins.ec2fleet.fleet.EC2Fleet;
import com.cloudbees.jenkins.plugins.awscredentials.AWSCredentialsHelper;
import com.cloudbees.jenkins.plugins.awscredentials.AmazonWebServicesCredentials;
import hudson.model.ItemGroup;
import hudson.util.ListBoxModel;
import java.net.URI;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import javax.annotation.concurrent.ThreadSafe;
import jenkins.model.Jenkins;
import org.apache.commons.lang.StringUtils;
import org.springframework.util.ObjectUtils;
import software.amazon.awssdk.core.client.config.ClientOverrideConfiguration;
import software.amazon.awssdk.http.SdkHttpClient;
import software.amazon.awssdk.regions.Region;
import software.amazon.awssdk.services.autoscaling.AutoScalingClient;
import software.amazon.awssdk.services.autoscaling.AutoScalingClientBuilder;
import software.amazon.awssdk.services.autoscaling.model.AutoScalingGroup;
import software.amazon.awssdk.services.autoscaling.model.DescribeAutoScalingGroupsRequest;
import software.amazon.awssdk.services.autoscaling.model.DescribeAutoScalingGroupsResponse;
import software.amazon.awssdk.services.autoscaling.model.Instance;
import software.amazon.awssdk.services.autoscaling.model.LaunchTemplate;
import software.amazon.awssdk.services.autoscaling.model.LaunchTemplateOverrides;
import software.amazon.awssdk.services.autoscaling.model.MixedInstancesPolicy;
import software.amazon.awssdk.services.autoscaling.model.TerminateInstanceInAutoScalingGroupRequest;
import software.amazon.awssdk.services.autoscaling.model.UpdateAutoScalingGroupRequest;

@ThreadSafe
public class AutoScalingGroupFleet
implements EC2Fleet {
    private static final Logger LOGGER = Logger.getLogger(AutoScalingGroupFleet.class.getName());

    @Override
    public void describe(String awsCredentialsId, String regionName, String endpoint, ListBoxModel model, String selectedId, boolean showAll) {
        AutoScalingClient client = this.createClient(awsCredentialsId, regionName, endpoint);
        DescribeAutoScalingGroupsRequest request = (DescribeAutoScalingGroupsRequest)DescribeAutoScalingGroupsRequest.builder().build();
        for (DescribeAutoScalingGroupsResponse result : client.describeAutoScalingGroupsPaginator(request)) {
            for (AutoScalingGroup group : result.autoScalingGroups()) {
                String curName = group.autoScalingGroupName();
                boolean selected = ObjectUtils.nullSafeEquals((Object)selectedId, (Object)curName);
                String displayStr = "Auto Scaling Group - " + curName;
                model.add((Object)new ListBoxModel.Option(displayStr, curName, selected));
            }
        }
    }

    @Override
    public void modify(String awsCredentialsId, String regionName, String endpoint, String id, int targetCapacity, int min, int max) {
        AutoScalingClient client = this.createClient(awsCredentialsId, regionName, endpoint);
        client.updateAutoScalingGroup((UpdateAutoScalingGroupRequest)UpdateAutoScalingGroupRequest.builder().minSize(Integer.valueOf(min)).maxSize(Integer.valueOf(max)).desiredCapacity(Integer.valueOf(targetCapacity)).autoScalingGroupName(id).newInstancesProtectedFromScaleIn(Boolean.valueOf(true)).build());
    }

    @Override
    public FleetStateStats getState(String awsCredentialsId, String regionName, String endpoint, String id) {
        AutoScalingClient client = this.createClient(awsCredentialsId, regionName, endpoint);
        DescribeAutoScalingGroupsResponse result = client.describeAutoScalingGroups((DescribeAutoScalingGroupsRequest)DescribeAutoScalingGroupsRequest.builder().autoScalingGroupNames(new String[]{id}).build());
        if (result.autoScalingGroups().isEmpty()) {
            throw new IllegalArgumentException(String.format("Cannot find auto scaling group with name %s in region %s", id, regionName));
        }
        AutoScalingGroup group = (AutoScalingGroup)result.autoScalingGroups().get(0);
        HashSet<String> instanceIds = new HashSet<String>(group.instances().size());
        for (Instance instance : group.instances()) {
            instanceIds.add(instance.instanceId());
        }
        Map<String, Double> instanceWeights = Optional.ofNullable(group.mixedInstancesPolicy()).map(MixedInstancesPolicy::launchTemplate).map(LaunchTemplate::overrides).map(overrides -> overrides.stream().filter(o -> o.weightedCapacity() != null).collect(Collectors.toMap(LaunchTemplateOverrides::instanceType, override -> Double.parseDouble(override.weightedCapacity())))).orElse(Collections.emptyMap());
        return new FleetStateStats(id, group.desiredCapacity(), FleetStateStats.State.active(StringUtils.defaultIfEmpty((String)group.status(), (String)"active")), instanceIds, instanceWeights);
    }

    @Override
    public Map<String, FleetStateStats> getStateBatch(String awsCredentialsId, String regionName, String endpoint, Collection<String> ids) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Boolean isAutoScalingGroup() {
        return true;
    }

    public AutoScalingClient createClient(String awsCredentialsId, String regionName, String endpoint) {
        String effectiveEndpoint;
        AutoScalingClientBuilder clientBuilder;
        AmazonWebServicesCredentials credentials = AWSCredentialsHelper.getCredentials((String)awsCredentialsId, (ItemGroup)Jenkins.get());
        ClientOverrideConfiguration clientConfiguration = AWSUtils.getClientConfiguration();
        AutoScalingClientBuilder autoScalingClientBuilder = clientBuilder = credentials != null ? (AutoScalingClientBuilder)((AutoScalingClientBuilder)AutoScalingClient.builder().credentialsProvider(AWSUtils.toSdkV2CredentialsProvider(credentials))).overrideConfiguration(clientConfiguration) : (AutoScalingClientBuilder)AutoScalingClient.builder().overrideConfiguration(clientConfiguration);
        if (StringUtils.isNotBlank((String)regionName)) {
            clientBuilder.region(Region.of((String)regionName));
        }
        if ((effectiveEndpoint = this.getEndpoint(regionName, endpoint)) != null) {
            clientBuilder.endpointOverride(URI.create(effectiveEndpoint));
        }
        clientBuilder.httpClient((SdkHttpClient)AWSUtils.getApacheHttpClient(endpoint));
        return (AutoScalingClient)clientBuilder.build();
    }

    public void terminateInstances(String awsCredentialsId, String regionName, String endpoint, Collection<String> instanceIds) {
        AutoScalingClient client = this.createClient(awsCredentialsId, regionName, endpoint);
        for (String instanceId : instanceIds) {
            if (StringUtils.isBlank((String)instanceId)) {
                throw new IllegalArgumentException("Instance ID cannot be null or empty");
            }
            try {
                client.terminateInstanceInAutoScalingGroup((TerminateInstanceInAutoScalingGroupRequest)TerminateInstanceInAutoScalingGroupRequest.builder().instanceId(instanceId).shouldDecrementDesiredCapacity(Boolean.valueOf(false)).build());
            }
            catch (Exception e) {
                LOGGER.warning(String.format("Failed to terminate instance %s in Auto Scaling group: %s", instanceId, e.getMessage()));
            }
        }
    }

    @Nullable
    private String getEndpoint(@Nullable String regionName, @Nullable String endpoint) {
        if (StringUtils.isNotEmpty((String)endpoint)) {
            return endpoint;
        }
        if (StringUtils.isNotEmpty((String)regionName)) {
            String domain = regionName.startsWith("cn-") ? "amazonaws.com.cn" : "amazonaws.com";
            return "https://autoscaling." + regionName + "." + domain;
        }
        return null;
    }
}

