/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.jenkins.ec2fleet;

import hudson.model.Computer;
import hudson.model.Node;
import hudson.util.DaemonThreadFactory;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.concurrent.ThreadSafe;

@ThreadSafe
class EC2FleetOnlineChecker
implements Runnable {
    private static final Logger LOGGER = Logger.getLogger(EC2FleetOnlineChecker.class.getName());
    private static final ScheduledExecutorService EXECUTOR = Executors.newSingleThreadScheduledExecutor((ThreadFactory)new DaemonThreadFactory());
    private final long start = System.currentTimeMillis();
    private final Node node;
    private final CompletableFuture<Node> future;
    private final long timeout;
    private final long interval;

    public static void start(Node node, CompletableFuture<Node> future, long timeout, long interval) {
        EXECUTOR.execute(new EC2FleetOnlineChecker(node, future, timeout, interval));
    }

    private EC2FleetOnlineChecker(Node node, CompletableFuture<Node> future, long timeout, long interval) {
        this.node = node;
        this.future = future;
        this.timeout = timeout;
        this.interval = interval;
    }

    @Override
    public void run() {
        if (this.future.isCancelled()) {
            return;
        }
        if (this.timeout < 1L || this.interval < 1L) {
            this.future.complete(this.node);
            LOGGER.log(Level.INFO, String.format("Node '%s' connection check disabled. Resolving planned node", this.node.getDisplayName()));
            return;
        }
        Computer computer = this.node.toComputer();
        if (computer != null && computer.isOnline()) {
            this.future.complete(this.node);
            LOGGER.log(Level.INFO, String.format("Node '%s' connected. Resolving planned node", this.node.getDisplayName()));
            return;
        }
        if (System.currentTimeMillis() - this.start > this.timeout) {
            this.future.completeExceptionally(new IllegalStateException("Failed to provision node. Could not connect to node '" + this.node.getDisplayName() + "' before timeout (" + this.timeout + "ms)"));
            return;
        }
        if (computer == null) {
            LOGGER.log(Level.INFO, String.format("No connection to node '%s'. Waiting before retry", this.node.getDisplayName()));
        } else {
            computer.connect(false);
            LOGGER.log(Level.INFO, String.format("No connection to node '%s'. Attempting to connect and waiting before retry", this.node.getDisplayName()));
        }
        EXECUTOR.schedule(this, this.interval, TimeUnit.MILLISECONDS);
    }
}

