/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.jenkins.ec2fleet;

import com.amazon.jenkins.ec2fleet.AbstractEC2FleetCloud;
import com.amazon.jenkins.ec2fleet.EC2ExecutorInterruptionCause;
import com.amazon.jenkins.ec2fleet.EC2FleetNodeComputer;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import hudson.model.Actionable;
import hudson.model.Executor;
import hudson.model.ParametersAction;
import hudson.model.Queue;
import hudson.model.Result;
import hudson.model.TaskListener;
import hudson.model.queue.SubTask;
import hudson.slaves.ComputerLauncher;
import hudson.slaves.DelegatingComputerLauncher;
import hudson.slaves.SlaveComputer;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.concurrent.ThreadSafe;
import jenkins.model.CauseOfInterruption;
import org.jenkinsci.plugins.workflow.job.WorkflowJob;
import org.jenkinsci.plugins.workflow.job.WorkflowRun;

@ThreadSafe
public class EC2FleetAutoResubmitComputerLauncher
extends DelegatingComputerLauncher {
    private static final Level LOG_LEVEL = Level.INFO;
    private static final Logger LOGGER = Logger.getLogger(EC2FleetAutoResubmitComputerLauncher.class.getName());
    private static final int RESCHEDULE_QUIET_PERIOD_SEC = 10;

    public EC2FleetAutoResubmitComputerLauncher(ComputerLauncher launcher) {
        super(launcher);
    }

    @SuppressFBWarnings(value={"BC_UNCONFIRMED_CAST"}, justification="to ignore EC2FleetNodeComputer cast")
    public void afterDisconnect(SlaveComputer computer, TaskListener listener) {
        if (computer == null) {
            return;
        }
        AbstractEC2FleetCloud cloud = ((EC2FleetNodeComputer)computer).getCloud();
        if (cloud == null) {
            LOGGER.warning("Cloud is null for computer " + computer.getDisplayName() + ". This should be autofixed in a few minutes, if not please create an issue for the plugin");
            return;
        }
        LOGGER.log(LOG_LEVEL, "DISCONNECTED: " + computer.getDisplayName());
        if (!cloud.isDisableTaskResubmit() && computer.isOffline()) {
            List executors = computer.getExecutors();
            LOGGER.log(LOG_LEVEL, "Start retriggering executors for " + computer.getDisplayName());
            for (Executor executor : executors) {
                Queue.Executable executable = executor.getCurrentExecutable();
                if (executable == null) continue;
                executor.interrupt(Result.ABORTED, new CauseOfInterruption[]{new EC2ExecutorInterruptionCause(computer.getDisplayName())});
                SubTask subTask = executable.getParent();
                Queue.Task task = subTask.getOwnerTask();
                ArrayList actions = new ArrayList();
                if (task instanceof WorkflowJob) {
                    WorkflowRun failedBuild = (WorkflowRun)((WorkflowJob)task).getLastFailedBuild();
                    actions.addAll(failedBuild.getActions(ParametersAction.class));
                }
                if (executable instanceof Actionable) {
                    actions.addAll(((Actionable)executable).getAllActions());
                }
                LOGGER.log(LOG_LEVEL, "RETRIGGERING: " + String.valueOf(task) + " - WITH ACTIONS: " + String.valueOf(actions));
                Queue.getInstance().schedule2(task, 10, actions);
            }
            LOGGER.log(LOG_LEVEL, "Finished retriggering executors for " + computer.getDisplayName());
        } else {
            LOGGER.log(LOG_LEVEL, "Skipping executable resubmission for " + computer.getDisplayName() + " - disableTaskResubmit: " + cloud.isDisableTaskResubmit() + " - offline: " + computer.isOffline());
        }
        super.afterDisconnect(computer, listener);
    }
}

