/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.jenkins.ec2fleet;

import com.amazon.jenkins.ec2fleet.AbstractEC2FleetCloud;
import com.amazon.jenkins.ec2fleet.EC2AgentTerminationReason;
import com.amazon.jenkins.ec2fleet.EC2FleetCloud;
import com.amazon.jenkins.ec2fleet.EC2FleetNode;
import com.amazon.jenkins.ec2fleet.EC2FleetNodeComputer;
import hudson.model.Computer;
import hudson.model.Executor;
import hudson.model.ExecutorListener;
import hudson.model.Queue;
import hudson.slaves.RetentionStrategy;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;

public class EC2RetentionStrategy
extends RetentionStrategy<EC2FleetNodeComputer>
implements ExecutorListener {
    private static final Logger LOGGER = Logger.getLogger(EC2RetentionStrategy.class.getName());
    private static final int RE_CHECK_IN_A_MINUTE = 1;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long check(EC2FleetNodeComputer fc) {
        AbstractEC2FleetCloud cloud = fc.getCloud();
        LOGGER.fine(String.format("Checking if node '%s' is idle ", fc.getName()));
        if (cloud == null) {
            LOGGER.warning("Cloud is null for computer " + fc.getDisplayName() + ". This should be autofixed in a few minutes, if not please create an issue for the plugin");
            return 1L;
        }
        boolean shouldAcceptTasks = fc.isAcceptingTasks();
        boolean markedForTermination = false;
        fc.setAcceptingTasks(false);
        try {
            if (fc.isIdle()) {
                EC2AgentTerminationReason reason;
                EC2FleetNode node = fc.getNode();
                if (node == null) {
                    long l = 1L;
                    return l;
                }
                if (fc.isMarkedForDeletion()) {
                    reason = EC2AgentTerminationReason.AGENT_DELETED;
                } else if (cloud.hasExcessCapacity()) {
                    reason = EC2AgentTerminationReason.EXCESS_CAPACITY;
                } else if (cloud instanceof EC2FleetCloud && !((EC2FleetCloud)cloud).hasUnlimitedUsesForNodes() && node.getUsesRemaining() <= 0) {
                    reason = EC2AgentTerminationReason.MAX_TOTAL_USES_EXHAUSTED;
                } else if (this.isIdleForTooLong(cloud, (Computer)fc)) {
                    reason = EC2AgentTerminationReason.IDLE_FOR_TOO_LONG;
                } else {
                    long l = 1L;
                    return l;
                }
                String instanceId = node.getNodeName();
                boolean ignoreMinConstraints = reason.equals((Object)EC2AgentTerminationReason.MAX_TOTAL_USES_EXHAUSTED);
                if (cloud.scheduleToTerminate(instanceId, ignoreMinConstraints, reason)) {
                    shouldAcceptTasks = false;
                    LOGGER.fine(String.format("Suspended node %s after scheduling instance for termination, reason: %s.", new Object[]{node.getDisplayName(), instanceId, reason}));
                    markedForTermination = true;
                }
            }
            if (cloud.isAlwaysReconnect() && !markedForTermination && fc.isOffline() && !fc.isConnecting() && fc.isLaunchSupported()) {
                LOGGER.log(Level.INFO, "Reconnecting to instance: " + fc.getDisplayName());
                fc.tryReconnect();
            }
        }
        finally {
            fc.setAcceptingTasks(shouldAcceptTasks);
        }
        return 1L;
    }

    public void start(EC2FleetNodeComputer c) {
        LOGGER.log(Level.INFO, "Connecting to instance: " + c.getDisplayName());
        c.connect(false);
    }

    private boolean isIdleForTooLong(AbstractEC2FleetCloud cloud, Computer computer) {
        long maxIdle;
        boolean isIdleForTooLong;
        int idleMinutes = cloud.getIdleMinutes();
        if (idleMinutes <= 0) {
            return false;
        }
        long idleTime = System.currentTimeMillis() - computer.getIdleStartMilliseconds();
        boolean bl = isIdleForTooLong = idleTime > (maxIdle = TimeUnit.MINUTES.toMillis(idleMinutes));
        if (isIdleForTooLong) {
            LOGGER.log(Level.INFO, "Instance {0} has been idle for too long (Age: {1}, Max Age: {2}).", new Object[]{computer.getDisplayName(), String.valueOf(idleTime), String.valueOf(maxIdle)});
        } else {
            LOGGER.log(Level.INFO, "Instance:" + computer.getDisplayName() + " Age: " + idleTime + " Max Age:" + maxIdle);
        }
        return isIdleForTooLong;
    }

    public void taskAccepted(Executor executor, Queue.Task task) {
        EC2FleetNode ec2FleetNode;
        EC2FleetNodeComputer computer = (EC2FleetNodeComputer)executor.getOwner();
        if (computer != null && (ec2FleetNode = computer.getNode()) != null) {
            int maxTotalUses = ec2FleetNode.getMaxTotalUses();
            if (maxTotalUses <= -1) {
                LOGGER.fine("maxTotalUses set to unlimited (" + maxTotalUses + ") for agent " + computer.getName());
            } else if (ec2FleetNode.getUsesRemaining() > 1) {
                ec2FleetNode.decrementUsesRemaining();
                LOGGER.info("Agent " + computer.getName() + " has " + ec2FleetNode.getUsesRemaining() + " builds left");
            } else if (ec2FleetNode.getUsesRemaining() == 1) {
                LOGGER.info(String.format("maxTotalUses drained - suspending agent %s after current build", computer.getName()));
                computer.setAcceptingTasks(false);
                ec2FleetNode.decrementUsesRemaining();
            } else {
                LOGGER.warning(String.format("Agent %s accepted a task after being suspended!!! MaxTotalUses: %d, uses remaining: %d", computer.getName(), ec2FleetNode.getMaxTotalUses(), ec2FleetNode.getUsesRemaining()));
            }
        }
    }

    public void taskCompleted(Executor executor, Queue.Task task, long l) {
        this.postJobAction(executor, null);
    }

    public void taskCompletedWithProblems(Executor executor, Queue.Task task, long l, Throwable throwable) {
        this.postJobAction(executor, throwable);
    }

    private void postJobAction(Executor executor, Throwable throwable) {
        EC2FleetNode ec2FleetNode;
        if (throwable != null) {
            LOGGER.warning(String.format("Build %s completed with problems on agent %s. TimeSpentInQueue: %ds, duration: %ds, problems: %s", executor.getCurrentExecutable(), executor.getOwner().getName(), TimeUnit.MILLISECONDS.toSeconds(executor.getTimeSpentInQueue()), TimeUnit.MILLISECONDS.toSeconds(executor.getElapsedTime()), throwable.getMessage()));
        } else {
            LOGGER.info(String.format("Build %s completed successfully on agent %s. TimeSpentInQueue: %ds, duration: %ds.", executor.getCurrentExecutable(), executor.getOwner().getName(), TimeUnit.MILLISECONDS.toSeconds(executor.getTimeSpentInQueue()), TimeUnit.MILLISECONDS.toSeconds(executor.getElapsedTime())));
        }
        EC2FleetNodeComputer computer = (EC2FleetNodeComputer)executor.getOwner();
        if (computer != null && (ec2FleetNode = computer.getNode()) != null) {
            AbstractEC2FleetCloud cloud = ec2FleetNode.getCloud();
            if (computer.countBusy() <= 1 && !computer.isAcceptingTasks()) {
                LOGGER.info("Calling scheduleToTerminate for node " + ec2FleetNode.getNodeName() + " due to exhausted maxTotalUses.");
                cloud.scheduleToTerminate(ec2FleetNode.getNodeName(), true, EC2AgentTerminationReason.MAX_TOTAL_USES_EXHAUSTED);
            }
        }
    }
}

