/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.jenkins.ec2fleet.aws;

import com.cloudbees.jenkins.plugins.awscredentials.AmazonWebServicesCredentials;
import hudson.ProxyConfiguration;
import java.net.InetSocketAddress;
import java.net.MalformedURLException;
import java.net.Proxy;
import java.net.URI;
import java.net.URL;
import java.util.List;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import jenkins.model.Jenkins;
import software.amazon.awssdk.auth.credentials.AwsCredentials;
import software.amazon.awssdk.auth.credentials.AwsCredentialsProvider;
import software.amazon.awssdk.auth.credentials.StaticCredentialsProvider;
import software.amazon.awssdk.core.client.config.ClientOverrideConfiguration;
import software.amazon.awssdk.core.client.config.SdkAdvancedClientOption;
import software.amazon.awssdk.core.retry.RetryMode;
import software.amazon.awssdk.core.retry.RetryPolicy;
import software.amazon.awssdk.http.apache.ApacheHttpClient;
import software.amazon.awssdk.http.apache.ProxyConfiguration;

public final class AWSUtils {
    private static final String USER_AGENT_PREFIX = "ec2-fleet-plugin";
    private static final int MAX_ERROR_RETRY = 5;

    public static ClientOverrideConfiguration getClientConfiguration() {
        ClientOverrideConfiguration.Builder builder = ClientOverrideConfiguration.builder();
        RetryPolicy.forRetryMode((RetryMode)RetryMode.STANDARD);
        ClientOverrideConfiguration.Builder overrideConfig = builder.retryPolicy(RetryPolicy.builder().numRetries(Integer.valueOf(5)).build()).putAdvancedOption(SdkAdvancedClientOption.USER_AGENT_PREFIX, (Object)USER_AGENT_PREFIX);
        return (ClientOverrideConfiguration)overrideConfig.build();
    }

    static ProxyConfiguration.Builder createSdkProxyBuilder() {
        return software.amazon.awssdk.http.apache.ProxyConfiguration.builder();
    }

    public static ApacheHttpClient getApacheHttpClient(String endpoint) {
        ProxyConfiguration proxyConfig = Jenkins.get().proxy;
        if (proxyConfig != null) {
            String host;
            try {
                host = new URL(endpoint).getHost();
            }
            catch (MalformedURLException e) {
                host = endpoint;
            }
            Proxy proxy = proxyConfig.createProxy(host);
            if (!proxy.equals(Proxy.NO_PROXY) && proxy.address() instanceof InetSocketAddress) {
                List patterns;
                InetSocketAddress address = (InetSocketAddress)proxy.address();
                String proxyHost = address.getHostName();
                int proxyPort = address.getPort();
                String proxyScheme = "http";
                URI proxyUri = URI.create(proxyScheme + "://" + proxyHost + ":" + proxyPort);
                ProxyConfiguration.Builder sdkProxyBuilder = AWSUtils.createSdkProxyBuilder();
                sdkProxyBuilder.endpoint(proxyUri);
                if (proxyConfig.getUserName() != null) {
                    sdkProxyBuilder.username(proxyConfig.getUserName());
                    sdkProxyBuilder.password(proxyConfig.getSecretPassword().getPlainText());
                }
                if ((patterns = proxyConfig.getNoProxyHostPatterns()) != null && !patterns.isEmpty()) {
                    sdkProxyBuilder.nonProxyHosts(patterns.stream().map(Pattern::pattern).collect(Collectors.toSet()));
                }
                return (ApacheHttpClient)ApacheHttpClient.builder().proxyConfiguration((software.amazon.awssdk.http.apache.ProxyConfiguration)sdkProxyBuilder.build()).build();
            }
        }
        return (ApacheHttpClient)ApacheHttpClient.builder().build();
    }

    public static AwsCredentialsProvider toSdkV2CredentialsProvider(AmazonWebServicesCredentials credentials) {
        if (credentials == null) {
            return null;
        }
        AwsCredentials creds = credentials.resolveCredentials();
        return StaticCredentialsProvider.create((AwsCredentials)creds);
    }

    private AWSUtils() {
        throw new UnsupportedOperationException("util class");
    }
}

