/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.jenkins.ec2fleet;

import com.amazon.jenkins.ec2fleet.EC2FleetLabelCloud;
import hudson.Extension;
import hudson.model.PeriodicWork;
import hudson.slaves.Cloud;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import jenkins.model.Jenkins;

@Extension
public class EC2FleetLabelUpdater
extends PeriodicWork {
    private static final Logger LOGGER = Logger.getLogger(EC2FleetLabelUpdater.class.getName());

    public long getRecurrencePeriod() {
        return TimeUnit.SECONDS.toMillis(30L);
    }

    protected void doRun() {
        for (Cloud cloud : Jenkins.get().clouds) {
            if (!(cloud instanceof EC2FleetLabelCloud)) continue;
            EC2FleetLabelCloud ec2FleetLabelCloud = (EC2FleetLabelCloud)cloud;
            try {
                ec2FleetLabelCloud.updateStacks();
            }
            catch (Throwable t) {
                LOGGER.log(Level.SEVERE, "Cloud stacks update error", t);
            }
            try {
                ec2FleetLabelCloud.update();
            }
            catch (Throwable t) {
                LOGGER.log(Level.SEVERE, "Cloud update error", t);
            }
        }
    }
}

